/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.GraphOptimization"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.CostDistribution"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.MonteCarloGraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.OptimizationResults"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var client= com.ibm.team.tempo.shared.client;
var CostDistribution= client.CostDistribution;
var MonteCarloGraphNode= client.MonteCarloGraphNode;
var OptimizationResults= client.OptimizationResults;

dojo.declare("com.ibm.team.tempo.shared.client.GraphOptimization", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//ownerGraphNodeTbl: null,

	//graph: null,

	//scheduleResult: null,

	overallCost: 0,

	constructor: function(schedule) {
		this.ownerGraphNodeTbl= null;
		this.graph= null;
		this.scheduleResult= null;
		this.overallCost= Number.MIN_VALUE;
		this.graph= schedule.getGraph();
		this.scheduleResult= schedule.getScheduleResult();
		this.ownerGraphNodeTbl= this.graph.getOwnerGraphNodeTbl();
	},

	/**
	 * Compute the total N times, summarizing the results.
	 * @param graph
	 * @param n Number of times cost is computed.
	 * @return OptimizationResults consisting of N, mean, average of the squares and 
	 *         the average exponential cost.  
	 */
	simulate: function(n) {
		return this.__doSimulate(n, false, true);
	},

	getOverallCost: function() {
		return this.overallCost;
	},

	getLookupCount: function(graph) {
		return graph.getLookupCount();
	},

	/**
	 * Implementation
	 */
	__doSimulate: function(n, showNodes, showNodeDistributions) {
		var monteCarloNodeTbl= this.__populateMonteCarloNodes(this.graph.getGraphNodeTbl(), n, showNodeDistributions);
		var costDistribution= new CostDistribution(n, null);
		var cost= 0.0;
		var lookupCount= 0;
		for (var i= 0; i < n; i++){
			this.overallCost= 0.0;
			this.graph.resetNodes();
			this.graph.run();
			if (this.scheduleResult == null) {
				this.__updateGraphMetrics(this.graph, monteCarloNodeTbl);
			} else {
				if (this.ownerGraphNodeTbl == null) {
					this.__updateSimpleScheduledMetrics(this.scheduleResult, monteCarloNodeTbl);
				} else {
					this.__updateOwnerScheduledMetrics(monteCarloNodeTbl, this.ownerGraphNodeTbl);
				}
			}
			this.__updateCriticalPathNodeCount(this.graph, monteCarloNodeTbl);
			cost= this.graph.getCritPathTotalCost();
			costDistribution.update(cost);
			lookupCount= lookupCount + this.getLookupCount(this.graph);
			if (showNodes) 
				this.graph.show();
		}
		var results= new OptimizationResults(costDistribution, lookupCount);
		results.setMonteCarloNodeTbl(monteCarloNodeTbl);
		return results;
	},

	__populateMonteCarloNodes: function(graphNodeTbl, n, showNodeDistributions) {
		var monteCarloNodeTbl= {};
		var $subject= jdojo.getProperties(graphNodeTbl);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var key= $subject[$count];
			monteCarloNodeTbl[key]= new MonteCarloGraphNode(graphNodeTbl[key], n, showNodeDistributions);
		}
		return monteCarloNodeTbl;
	},

	__updateCriticalPathNodeCount: function(graph, monteCarloNodeTbl) {
		var graphNode= graph.getCriticalPathTailNode();
		while(graphNode != null){
			var monteCarloGraphNode= monteCarloNodeTbl[graphNode.getId()];
			monteCarloGraphNode.incrementOnCritPathCount();
			graphNode= graphNode.getConstraintPredecessor();
		}
	},

	__updateGraphMetrics: function(graph, monteCarloNodeTbl) {
		var graphNodeTbl= graph.getGraphNodeTbl();
		var $subject2= jdojo.getProperties(graphNodeTbl);
		var $length2= $subject2.length;
		for (var $count2= 0; $count2 < $length2; $count2++){
			var nodeId= $subject2[$count2];
			var graphNode= graphNodeTbl[nodeId];
			var monteCarloGraphNode= monteCarloNodeTbl[nodeId];
			this.__updateMetrics(graphNode, monteCarloGraphNode);
		}
	},

	__updateSimpleScheduledMetrics: function(scheduleResult, monteCarloNodeTbl) {
		for (var i= 0; i < scheduleResult.length; i++){
			var graphNode= scheduleResult[i];
			var monteCarloGraphNode= monteCarloNodeTbl[graphNode.getId()];
			this.__updateMetrics(graphNode, monteCarloGraphNode);
			this.overallCost= this.overallCost + graphNode.getTotalCost();
			monteCarloGraphNode.updateAbleToCompleteCount(this.overallCost, graphNode.getTargetCost());
			monteCarloGraphNode.updateEffectiveAbilityToCompleteCount(this.overallCost, graphNode.getEffectiveTargetCost());
		}
	},

	__updateOwnerScheduledMetrics: function(monteCarloNodeTbl, ownerGraphNodeTbl) {
		var overallCost= 0.0;
		var $subject3= jdojo.getProperties(ownerGraphNodeTbl);
		var $length3= $subject3.length;
		for (var $count3= 0; $count3 < $length3; $count3++){
			var ownerId= $subject3[$count3];
			var overallUserCost= 0.0;
			var ownerNodeLst= ownerGraphNodeTbl[ownerId];
			for (var j= 0; j < ownerNodeLst.length; j++){
				var graphNode= ownerNodeLst[j];
				var monteCarloGraphNode= monteCarloNodeTbl[graphNode.getId()];
				this.__updateMetrics(graphNode, monteCarloGraphNode);
				overallUserCost= overallUserCost + graphNode.getTotalCost() + graphNode.getSlack();
				monteCarloGraphNode.updateAbleToCompleteCount(overallUserCost, graphNode.getTargetCost());
				monteCarloGraphNode.updateEffectiveAbilityToCompleteCount(overallUserCost, graphNode.getEffectiveTargetCost());
			}
			overallCost= Math.max(overallCost, overallUserCost);
		}
	},

	__updateMetrics: function(graphNode, monteCarloGraphNode) {
		monteCarloGraphNode.updateCostFields(graphNode.getCost());
		monteCarloGraphNode.updateSlack(graphNode.getSlack());
		monteCarloGraphNode.updateSlackPlusTotCost(graphNode.getTotalCost() + graphNode.getSlack());
	}
});

})();
