/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.GraphNode"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.TriangularEstimate"); //$NON-NLS-1$

(function() {
var TriangularEstimate= com.ibm.team.tempo.shared.client.TriangularEstimate;

dojo.declare("com.ibm.team.tempo.shared.client.GraphNode", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//estimate: null,

	startCost: 0,

	cost: 0,

	actualCost: 0,

	cumulativeCost: 0,

	slack: 0,

	impact: 0,

	targetCost: 0,

	effectiveTargetCost: 0,

	targetCompletionCost: 0,

	//owner: null,

	//isRandomVariateFlag: null,

	//isProcessedNodeFlag: null,

	//constraintPredecessor: null,

	priority: 0,

	unprocessedPredecessors: 0,

	//successors: null,

	//predecessors: null,

	//id: null,

	//parent: null,

	constructor: function(id, estimateOrActualCost) {
		this.estimate= null;
		this.startCost= 0.0;
		this.cost= 0.0;
		this.actualCost= 0.0;
		this.cumulativeCost= 0.0;
		this.slack= 0.0;
		this.impact= 0.0;
		this.targetCost= Number.NaN;
		this.effectiveTargetCost= Number.NaN;
		this.targetCompletionCost= Number.NaN;
		this.owner= ""; //$NON-NLS-1$
		this.isRandomVariateFlag= false;
		this.isProcessedNodeFlag= false;
		this.constraintPredecessor= null;
		this.priority= 0;
		this.unprocessedPredecessors= 0;
		this.successors= null;
		this.predecessors= null;
		this.id= id;
		if (!(estimateOrActualCost instanceof TriangularEstimate)) {
			var actualCost= estimateOrActualCost;
			this.setActualCost(actualCost);
		} else {
			var estimate= estimateOrActualCost;
			this.setEstimate(estimate);
		}
		this.parent= null;
	},

	/**
	 * API
	 */
	getParent: function() {
		return this.parent;
	},

	setParent: function(parent) {
		this.parent= parent;
	},

	getId: function() {
		return this.id;
	},

	getOwner: function() {
		return this.owner;
	},

	setOwner: function(owner) {
		this.owner= owner;
	},

	getPriority: function() {
		return this.priority;
	},

	setPriority: function(priority) {
		this.priority= priority;
	},

	isProcessedNode: function() {
		return this.isProcessedNodeFlag;
	},

	setProcessedNode: function(isProcessedNode) {
		this.isProcessedNodeFlag= isProcessedNode;
	},

	getStartCost: function() {
		return this.startCost;
	},

	setStartCost: function(startCost) {
		this.startCost= startCost;
	},

	getSlack: function() {
		return this.slack;
	},

	setSlack: function(slack) {
		this.slack= slack;
	},

	getImpact: function() {
		return this.impact;
	},

	setImpact: function(impact) {
		this.impact= impact;
	},

	getCumulativeCost: function() {
		return this.cumulativeCost;
	},

	setCumulativeCost: function(cumulativeCost) {
		this.cumulativeCost= cumulativeCost;
	},

	getTargetCost: function() {
		return this.targetCost;
	},

	setTargetCost: function(targetCost) {
		this.targetCost= targetCost;
	},

	/**
	 * @return cost for this node plus predecessor
	 */
	getEffectiveTargetCost: function() {
		return this.effectiveTargetCost;
	},

	setEffectiveTargetCost: function(effectiveTargetCost) {
		this.effectiveTargetCost= effectiveTargetCost;
	},

	/**
	 * @return cost for the overall cycle (iteration)
	 */
	getTargetCompletionCost: function() {
		return this.targetCompletionCost;
	},

	getConstraintPredecessor: function() {
		return this.constraintPredecessor;
	},

	setConstraintPredecessor: function(constraintPredecessor) {
		this.constraintPredecessor= constraintPredecessor;
	},

	getCost: function() {
		return this.cost;
	},

	getActualCost: function() {
		return this.actualCost;
	},

	setActualCost: function(actualCost) {
		this.actualCost= actualCost;
	},

	getTotalCost: function() {
		return this.getStartCost() + this.getCost();
	},

	getUnprocessedPredecessors: function() {
		return this.unprocessedPredecessors;
	},

	setUnprocessedPredecessors: function(unprocessedPredecessors) {
		this.unprocessedPredecessors= unprocessedPredecessors;
	},

	decrementUnprocessedPredecessors: function() {
		this.unprocessedPredecessors--;
	},

	addSuccessor: function(successor) {
		if (successor != null) 
			this.getSuccessors().push(successor);
	},

	getSuccessors: function() {
		if (this.successors == null) 
			this.successors= [];
		return this.successors;
	},

	addPredecessor: function(predecessor) {
		if (predecessor != null) 
			this.getPredecessors().push(predecessor);
	},

	getPredecessors: function() {
		if (this.predecessors == null) 
			this.predecessors= [];
		return this.predecessors;
	},

	clearPredecessors: function() {
		this.predecessors= null;
	},

	getNrOfPredecessors: function() {
		return this.getPredecessors().length;
	},

	isRandomVariate: function() {
		return this.isRandomVariateFlag;
	},

	setSuccessors: function(successors) {
		this.successors= successors;
	},

	getEstimate: function() {
		return this.estimate;
	},

	setEstimate: function(estimate) {
		this.estimate= estimate;
		this.isRandomVariateFlag= true;
	},

	toString: function() {
		return this.getId();
	},

	show: function(withSlack) {
		var buf= ""; //$NON-NLS-1$
		buf+= " Id=" + this.getId(); //$NON-NLS-1$
		buf+= " owner=" + this.getOwner(); //$NON-NLS-1$
		buf+= " estimate=[" + this.estimate + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		buf+= " startCost=" + this.getStartCost(); //$NON-NLS-1$
		buf+= " cost=" + Math.round(this.getCost()); //$NON-NLS-1$
		buf+= " impact=" + this.impact; //$NON-NLS-1$
		buf+= " cumulativeCost=" + Math.round(this.getCumulativeCost()); //$NON-NLS-1$
		if (withSlack) {
			buf+= " slack=" + this.getSlack(); //$NON-NLS-1$
		}
		buf+= " predecessors=[" + this.getPredecessors() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		buf+= " successors=[" + this.getSuccessors() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		return buf;
	},

	reset: function() {
		this.setSlack(0.0);
		this.setCumulativeCost(0.0);
		this.setUnprocessedPredecessors(0);
		this.setProcessedNode(false);
		this.constraintPredecessor= null;
	},

	computeCost: function() {
		if (this.actualCost > 0.0) 
			this.cost= this.actualCost;
		else {
			this.estimate.computeCost();
			this.cost= this.estimate.getCost();
		}
	}
});

})();
