/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2010, 2014. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.Graph"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.lang.Runtime"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.GraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.NbTraverser"); //$NON-NLS-1$

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var client= com.ibm.team.tempo.shared.client;
var GraphNode= client.GraphNode;
var NbTraverser= client.NbTraverser;

/**
 * Graph - Build the graph.
 * Abort if a successor is not found.
 * @author rmd
 */
dojo.declare("com.ibm.team.tempo.shared.client.Graph", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//origNodeLst: null,

	//graphNodeTbl: null,

	//headNodeLst: null,

	//successorIdLst: null,

	//traverser: null,

	//criticalPathTailNode: null,

	//fisRandomVariate: null,

	//isSuccessorValidated: null,

	critPathTotalCost: 0,

	lookupCount: 0,

	constructor: function() {
		this.origNodeLst= [];
		this.graphNodeTbl= {};
		this.headNodeLst= [];
		this.successorIdLst= [];
		this.traverser= new NbTraverser();
		this.criticalPathTailNode= null;
		this.fisRandomVariate= false;
		this.isSuccessorValidated= false;
		this.critPathTotalCost= 0.0;
		this.lookupCount= 0;
	},

	/**
	 * API
	 */
	add: function(graphNodeOrLst) {
		var graphNodeLst= null;
		if (graphNodeOrLst instanceof GraphNode) {
			var node= graphNodeOrLst;
			graphNodeLst= [];
			graphNodeLst.push(node);
		} else {
			graphNodeLst= graphNodeOrLst;
		}
		for (var i= 0; i < graphNodeLst.length; i++){
			var graphNode= graphNodeLst[i];
			this.graphNodeTbl[graphNode.getId()]= graphNode;
			this.origNodeLst.push(graphNode);
			if (graphNode.isRandomVariate()) {
				this.setRandomVariate(true);
			}
			var successorLst= graphNode.getSuccessors();
			if (successorLst != null) {
				for (var s= 0; s < successorLst.length; s++){
					var successorId= successorLst[s];
					if (dojo.indexOf(this.successorIdLst, successorId) < 0) {
						this.successorIdLst.push(successorId);
					}
				}
			}
		}
		this.isSuccessorValidated= false;
	},

	/**
	 * An array of the nodes of this graph
	 */
	getOrigNodeLst: function() {
		return this.origNodeLst;
	},

	/**
	 * Maps graph node id's to their actual nodes in the graph
	 */
	getGraphNodeTbl: function() {
		return this.graphNodeTbl;
	},

	getCriticalPath: function() {
		var criticalPathLst= [];
		var criticalPathBackwardLst= [];
		var graphNode= this.criticalPathTailNode;
		while(graphNode != null){
			criticalPathBackwardLst.push(graphNode);
			graphNode= graphNode.getConstraintPredecessor();
		}
		for (var i= criticalPathBackwardLst.length - 1; i === 0; i--){
			criticalPathLst.push(criticalPathBackwardLst[i]);
		}
		return criticalPathLst;
	},

	getCritPathTotalCost: function() {
		return this.critPathTotalCost;
	},

	isRandomVariate: function() {
		return this.fisRandomVariate;
	},

	getCriticalPathTailNode: function() {
		return this.criticalPathTailNode;
	},

	/**
	 * Traverse the graph one time. Compute lookup count and critical path data.
	 * @throws MalformedGraphException
	 */
	run: function() {
		this.run_graph(null);
	},

	resetSuccessorValidated: function() {
		this.isSuccessorValidated= false;
	},

	accept: function(traverser) {
		this.traverser= traverser;
	},

	getLookupCount: function() {
		return this.lookupCount;
	},

	resetNodes: function() {
		var $subject= jdojo.getProperties(this.graphNodeTbl);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var key= $subject[$count];
			this.graphNodeTbl[key].reset();
		}
	},

	getHeadNodes: function() {
		return this.headNodeLst;
	},

	buildHeadNodeLst: function() {
		if (this.headNodeLst.length > 0) 
			return ;
		this.headNodeLst= [];
		var $subject2= jdojo.getProperties(this.graphNodeTbl);
		var $length2= $subject2.length;
		for (var $count2= 0; $count2 < $length2; $count2++){
			var key= $subject2[$count2];
			var graphNode= this.graphNodeTbl[key];
			if (dojo.indexOf(this.successorIdLst, graphNode.getId()) < 0) 
				this.headNodeLst.push(graphNode);
		}
	},

	initUnproccessedPredecessorCount: function() {
		var $subject3= jdojo.getProperties(this.graphNodeTbl);
		var $length3= $subject3.length;
		for (var $count3= 0; $count3 < $length3; $count3++){
			var key= $subject3[$count3];
			var graphNode= this.graphNodeTbl[key];
			graphNode.setUnprocessedPredecessors(graphNode.getNrOfPredecessors());
		}
	},

	initPredecessorCount: function() {
		var $subject4= jdojo.getProperties(this.graphNodeTbl);
		var $length4= $subject4.length;
		for (var $count4= 0; $count4 < $length4; $count4++){
			var key= $subject4[$count4];
			var graphNode= this.graphNodeTbl[key];
			var successors= graphNode.getSuccessors();
			for (var j= 0; j < successors.length; j++){
				var successorId= successors[j];
				var successor= this.graphNodeTbl[successorId];
				successor.addPredecessor(graphNode);
			}
		}
	},

	show: function() {
		var $subject5= jdojo.getProperties(this.graphNodeTbl);
		var $length5= $subject5.length;
		for (var $count5= 0; $count5 < $length5; $count5++){
			var key= $subject5[$count5];
			var graphNode= this.graphNodeTbl[key];
			graphNode.show(this.traverser.getOwnerNodeTbl() != null);
		}
	},

	toString: function() {
		var str= ""; //$NON-NLS-1$
		var $subject6= jdojo.getProperties(this.graphNodeTbl);
		var $length6= $subject6.length;
		for (var $count6= 0; $count6 < $length6; $count6++){
			var key= $subject6[$count6];
			var graphNode= this.graphNodeTbl[key];
			str+= graphNode.show(this.traverser.getOwnerNodeTbl() != null);
		}
		return str;
	},

	run_graph: function(ownerGraphNodeTbl) {
		if (this.isSuccessorValidated === false) {
			this.isSuccessorValidated= true;
			this.initPredecessorCount();
		}
		this.computeCost();
		this.buildHeadNodeLst();
		this.traverser.run(this, ownerGraphNodeTbl);
		this.setCritPathTotalCost(this.traverser.getCost());
		this.setCritPathTailNode(this.traverser.getCriticalPathTailNode());
		this.setLookupCount(this.traverser.getLookupCount());
	},

	computeCost: function() {
		var $subject7= jdojo.getProperties(this.graphNodeTbl);
		var $length7= $subject7.length;
		for (var $count7= 0; $count7 < $length7; $count7++){
			var key= $subject7[$count7];
			var graphNode= this.graphNodeTbl[key];
			graphNode.computeCost();
		}
	},

	setRandomVariate: function(isRandomVariate) {
		this.fisRandomVariate= isRandomVariate;
	},

	setCritPathTotalCost: function(critPathTotalCost) {
		this.critPathTotalCost= critPathTotalCost;
	},

	setLookupCount: function(lookupCount) {
		this.lookupCount= lookupCount;
	},

	setCritPathTailNode: function(criticalPathTailNode) {
		this.criticalPathTailNode= criticalPathTailNode;
	},

	validateSuccessors: function() {
	}
});

})();
