/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.CostDistributionRpt"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.ACostDistributionRpt"); //$NON-NLS-1$

(function() {
var ACostDistributionRpt= com.ibm.team.tempo.shared.client.ACostDistributionRpt;

dojo.declare("com.ibm.team.tempo.shared.client.CostDistributionRpt", ACostDistributionRpt, { //$NON-NLS-1$

	constructor: function(dist) {
		this.inherited(arguments, [dist]);
	},

	/**
	 * Print the distribution to the console.
	 */
	run: function() {
		var title= "Cost Distribution Report"; //$NON-NLS-1$
		var midpoint;
		this.addHeader(title, "  Count", this.dist.getMaxCount()); //$NON-NLS-1$
		for (var i= 0; i < this.dist.getNrOfBins(); i++){
			midpoint= this.dist.getMidpointStr(i);
			this.addDetail(midpoint, this.dist.getCountOfBin(i), 0);
		}
		this.addUnivariateStats();
	}
});

})();
