/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2012. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.CostDistribution"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.ACostDistributionRpt"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.CostCumulativePctDistributionRpt"); //$NON-NLS-1$

(function() {
var client= com.ibm.team.tempo.shared.client;
var ACostDistributionRpt= client.ACostDistributionRpt;
var CostCumulativePctDistributionRpt= client.CostCumulativePctDistributionRpt;

var CostDistribution= dojo.declare("com.ibm.team.tempo.shared.client.CostDistribution", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//NR_OF_DATA_PTS: null,

	//NR_OF_BINS: null,

	//distribution: null,

	//binCeiling: null,

	//data: null,

	//moments: null,

	//binRange: null,

	//minCost: null,

	//maxCost: null,

	//varCost: null,

	//stdCost: null,

	//totCost: null,

	//totCount: null,

	//nrOfDataPts: null,

	//maxCount: null,

	//midpointFractionalDigits: null,

	constructor: function(nrOfIterations, binCount) {
		this.NR_OF_DATA_PTS= 0;
		this.NR_OF_BINS= 100;
		this.binRange= Number.MIN_VALUE;
		this.minCost= Number.MAX_VALUE;
		this.maxCost= Number.MIN_VALUE;
		this.varCost= Number.MIN_VALUE;
		this.stdCost= Number.MIN_VALUE;
		this.totCost= Number.MIN_VALUE;
		this.totCount= 0;
		this.nrOfDataPts= 0;
		this.maxCount= ((Number.MIN_VALUE)|0);
		this.midpointFractionalDigits= 0;
		this.NR_OF_DATA_PTS= nrOfIterations;
		this.NR_OF_BINS= (binCount != null ? binCount : this.NR_OF_BINS);
		this.data= [];
		this.distribution= [];
		this.binCeiling= [];
		this.moments= [];
	},

	/**
	 * @param cost The input data to the distribution.
	 */
	update: function(cost) {
		this.data[this.nrOfDataPts++]= cost;
		this.minCost= Math.min(cost, this.minCost);
		this.maxCost= Math.max(cost, this.maxCost);
		this.totCost= this.totCost + cost;
		if (this.nrOfDataPts === this.NR_OF_DATA_PTS) {
			this.buildBinCeilings();
			this.buildDistribution();
			this.computeMaxCount();
			this.computeCostSTD();
			this.computeMoments();
			if (this.totCount !== this.NR_OF_DATA_PTS) {
			}
		}
	},

	/**
	 * @return The total number of data items. 
	 */
	getN: function() {
		return this.NR_OF_DATA_PTS;
	},

	/**
	 * @return The total number of bins in the distribution. 
	 */
	getNrOfBins: function() {
		return this.NR_OF_BINS;
	},

	/**
	 * @param binIndex The bin number, starting at zero.
	 * @return The number of accumulated items for this bin.
	 */
	getCountOfBin: function(binIndex) {
		return this.distribution[binIndex];
	},

	/**
	 * @return The maximum number of items that any bin accumulated.
	 */
	getMaxCount: function() {
		return this.maxCount;
	},

	/**
	 * @return The minimum cost across all the data.
	 */
	getMinCost: function() {
		return this.minCost;
	},

	/**
	 * @return The maximum cost across all the data.
	 */
	getMaxCost: function() {
		return this.maxCost;
	},

	/**
	 * @return The average cost across all the data.
	 */
	getAvgCost: function() {
		return this.totCost / (0.0 + this.NR_OF_DATA_PTS);
	},

	/**
	 * @return The variance across all the data.
	 */
	getVarCost: function() {
		return this.varCost;
	},

	/**
	 * @return The standard deviation cost across all the data.
	 */
	getStdCost: function() {
		return this.stdCost;
	},

	/**
	 * Print the distribution as a percent to the console.
	 */
	showCumulativePct: function() {
		var rpt= new CostCumulativePctDistributionRpt(this);
		rpt.run();
	},

	getMoments: function() {
		return this.moments;
	},

	/**
	 * @param binIndex The bin number, starting at zero.
	 * @return The percentage of items represented by this bin. 
	 */
	getBinPercent: function(binIndex) {
		return (this.distribution[binIndex] + 0.0) / (this.NR_OF_DATA_PTS * 100.0);
	},

	/**
	 * Compute the midpoint for the distribution bin.
	 * @param binIndex The bin number, starting at zero.
	 * @return Midpoint for the distribution bin.
	 */
	getMidpoint: function(binIndex) {
		return this.binCeiling[binIndex] - (this.binRange / 2.0);
	},

	/**
	 * Compute the midpoint for the distribution bin.
	 * Format the midpoint as a string which will be the same size as the others. 
	 * @param binIndex The bin number, starting at zero.
	 * @return Midpoint for the distribution bin.
	 */
	getMidpointStr: function(binIndex) {
		var midpoint= this.getMidpoint(binIndex);
		var fractionalDigits= this.getMidpointFractionalDigits();
		if (fractionalDigits > 0 || this.binRange === 1.) {
			fractionalDigits++;
		}
		return ACostDistributionRpt.format(midpoint, fractionalDigits).toString();
	},

	getData: function() {
		return this.data;
	},

	/**
	 * @return The number of fractional digits for the midpoint.
	 */
	getMidpointFractionalDigits: function() {
		return this.midpointFractionalDigits;
	},

	/**
	 * Compute the maximum unique value for each bin.
	 * Compute the largest precision that will support the number of bins. 
	 */
	buildBinCeilings: function() {
		var isBinRangeAdequate= false;
		var prevBinCeiling= Number.MIN_VALUE;
		for (var j= 0; j < 8; j++){
			this.binRange= (this.getMaxCost() - this.getMinCost()) / (0.0 + this.NR_OF_BINS);
			if (this.binRange === 0) {
				this.binRange= this.getMaxCost() / (0.0 + this.NR_OF_BINS);
			}
			if (this.binRange === 0) 
				if (this.midpointFractionalDigits === CostDistribution.MAX_MIDPT_FRACTIONAL_DIGITS) 
					if (this.binRange >= 1.0) {
						this.binRange= parseFloat(ACostDistributionRpt.format(this.binRange, this.midpointFractionalDigits));
					}
			for (var i= 0; i < this.NR_OF_BINS; i++){
				this.binCeiling[i]= this.getMaxCost() - (this.binRange * (this.NR_OF_BINS - (i + 1.0)));
				if (prevBinCeiling === this.binCeiling[i] || (this.getMaxCost() - this.getMinCost() > 0. && this.binCeiling[i] < this.getMinCost())) {
					isBinRangeAdequate= false;
					this.midpointFractionalDigits++;
					break;
				} else {
					prevBinCeiling= this.binCeiling[i];
				}
				isBinRangeAdequate= true;
			}
		}
	},

	/**
	 * Populate the distribution.
	 */
	buildDistribution: function() {
		var i;
		var cost= 0;
		for (i= 0; i < this.NR_OF_BINS; i++){
			this.distribution[i]= 0;
		}
		for (i= 0; i < this.NR_OF_DATA_PTS; i++){
			cost= this.data[i];
			for (var j= 0; j < this.NR_OF_BINS; j++){
				if (cost <= this.binCeiling[j]) {
					this.distribution[j]++;
					break;
				}
			}
		}
	},

	/**
	 * Compute the maximum number of items that any bin accumulated.
	 */
	computeMaxCount: function() {
		for (var i= 0; i < this.NR_OF_BINS; i++){
			this.maxCount= Math.max(this.distribution[i], this.maxCount);
			this.totCount= this.totCount + this.distribution[i];
		}
	},

	/**
	 * Compute the standard deviation cost.
	 */
	computeCostSTD: function() {
		var diffSqrSum= 0;
		var diff= 0;
		for (var i= 0; i < this.NR_OF_DATA_PTS; i++){
			diff= this.data[i] - this.getAvgCost();
			diffSqrSum= diffSqrSum + Math.pow(diff, 2);
		}
		this.varCost= diffSqrSum / (this.NR_OF_DATA_PTS - 1.0);
		this.stdCost= Math.sqrt(this.varCost);
	},

	computeMoments: function() {
		for (var i= 0; i < this.NR_OF_DATA_PTS; i++){
			this.moments[0]+= 1;
			this.moments[1]+= this.data[i];
			this.moments[2]+= this.data[i] * this.data[i];
			this.moments[3]+= this.data[i] * this.data[i] * this.data[i];
		}
	}
});

CostDistribution.MAX_MIDPT_FRACTIONAL_DIGITS= 10;

})();
