/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2010, 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.tempo.shared.client.ACostDistributionRpt"); //$NON-NLS-1$


(function() {
var ACostDistributionRpt= dojo.declare("com.ibm.team.tempo.shared.client.ACostDistributionRpt", null, { //$NON-NLS-1$
	"-chains-": { constructor: "manual" },

	//rptBuf: null,

	//fillBuf: null,

	scaleFactor: 0,

	dataLabelSize: 0,

	//dist: null,

	constructor: function(dist) {
		this.rptBuf= ""; //$NON-NLS-1$
		this.fillBuf= ""; //$NON-NLS-1$
		this.scaleFactor= ((Number.NaN)|0);
		this.dataLabelSize= ((Number.NaN)|0);
		this.dist= dist;
	},

	/**
	 * API
	 */
	getScaleFactor: function(maxCount) {
		var scaleFactor= 0;
		var scaledCount;
		var maxPoints= 50.0;
		do {
			scaleFactor++;
			scaledCount= Math.round(((maxCount / scaleFactor)|0));
		} while(scaledCount > maxPoints)
		return scaleFactor;
	},

	addHeader: function(title, dataLabel, maxCount) {
		var scaleFactorMsg= ""; //$NON-NLS-1$
		this.dataLabelSize= dataLabel.length + 1;
		this.scaleFactor= this.getScaleFactor(maxCount);
		if (this.scaleFactor > 1) {
			scaleFactorMsg= this.getScaleFactorMsg(this.scaleFactor);
		}
		this.rptBuf= ""; //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + ACostDistributionRpt.NEW_LINE + title;
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "Midpoint  " + dataLabel + scaleFactorMsg; //$NON-NLS-1$
	},

	addDetail: function(midpoint, data, fractionalDigits) {
		var unit= ""; //$NON-NLS-1$
		unit= ACostDistributionRpt.format(data, fractionalDigits);
		this.rptBuf+= ACostDistributionRpt.NEW_LINE;
		this.rptBuf+= this.getFill(ACostDistributionRpt.MIDPOINT_SIZE - midpoint.length) + midpoint;
		this.rptBuf+= ACostDistributionRpt.BLANK;
		this.rptBuf+= this.getFill(this.dataLabelSize - unit.length) + unit;
		this.rptBuf+= ACostDistributionRpt.BLANK;
		var val= Math.round((data / this.scaleFactor));
		this.rptBuf+= this.repeat("*", ((val)|0)); //$NON-NLS-1$
	},

	addUnivariateStats: function() {
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + ACostDistributionRpt.NEW_LINE + "Univariate Statistics"; //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "  Number of data points = " + this.dist.getN(); //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "  Minimum  = " + ACostDistributionRpt.format(this.dist.getMinCost(), 2); //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "  Average  = " + ACostDistributionRpt.format(this.dist.getAvgCost(), 2); //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "  Maximum  = " + ACostDistributionRpt.format(this.dist.getMaxCost(), 2); //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "  Variance = " + ACostDistributionRpt.format(this.dist.getVarCost(), 2); //$NON-NLS-1$
		this.rptBuf+= ACostDistributionRpt.NEW_LINE + "  Standard deviation = " + ACostDistributionRpt.format(this.dist.getStdCost(), 2); //$NON-NLS-1$
	},

	getScaleFactorMsg: function(scaleFactor) {
		return ", where each '*' represents " + scaleFactor + " data points."; //$NON-NLS-1$ //$NON-NLS-2$
	},

	getFill: function(size) {
		return this.repeat(ACostDistributionRpt.BLANK, size);
	},

	/**
	 * @param value A string value.
	 * @param size The desired size of the string.
	 * @return A string of repeating string values.
	 */
	repeat: function(value, size) {
		this.fillBuf= ""; //$NON-NLS-1$
		for (var i= 0; i < size; i++){
			this.fillBuf+= value;
		}
		return this.fillBuf;
	},

	print: function() {
	},

	getRptText: function() {
		return this.rptBuf;
	}
});

ACostDistributionRpt.format= function(value, fractionalDigits) {
	return (value).toFixed(fractionalDigits);
};
ACostDistributionRpt.NEW_LINE= "\n"; //$NON-NLS-1$
ACostDistributionRpt.BLANK= " "; //$NON-NLS-1$
ACostDistributionRpt.MIDPOINT_SIZE= 8;

})();
