/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.Estimate"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.TriangularDistribution"); //$NON-NLS-1$

(function() {

var Estimate						= com.ibm.team.tempo.shared.client.internal.simulation.Estimate;
var TriangularDistribution			= com.ibm.team.tempo.shared.client.internal.simulation.TriangularDistribution;
	
dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate", Estimate, { //$NON-NLS-1$

	constructor: function(lowerBound, middle, upperBound, type) {
		this.pd = null;
		this.setRandomVariate(true);
		
		this.lowerBound = lowerBound;
		this.middle = middle;
		this.upperBound = upperBound;
		
		if (!type || type == TriangularDistribution.NAME) {
			this.pd = new TriangularDistribution(lowerBound, middle, upperBound);
		}
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	computeCost: function() {
		this.setCost(this.pd.randomCost(Math.random()));
	},

	getLowerBound: function() {
		return this.lowerBound;
	},

	getMiddle: function() {
		return this.middle;
	},
	
	getUpperBound: function() {
		return this.upperBound;
	},
	
	scale: function(r) {
		return this.pd.scale(r);
	},

	getPd: function() {
		return this.pd;
	},
	
	toString: function() {
		var buf = "lowerBound="; //$NON-NLS-1$
		buf += this.lowerBound;
		buf += " middle="; //$NON-NLS-1$
		buf += this.middle;
		buf += " upperBound="; //$NON-NLS-1$
		buf += this.upperBound;
		buf += " type="; //$NON-NLS-1$
		buf += this.pd.getName().substring(0,3);
		return buf;
	},
	
	equals: function(o){
		if (this == o) return true;
		if (o instanceof ProbabilityDistribution){
			return ((this.getLowerBound() == pd.getLowerbound())&&
					(this.getMiddle() == pd.getMiddle())&&
					(this.getUpperBound() == pd.getUpperbound()));
		}
		return false;
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

