/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.Tempo"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.shared.client.plancheck.PlanCheck"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.CommonNewCodeMediatorForMultiOwners"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.MyAbstractWorkItem"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.tempo.shared.client.internal", "SimulationMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var PlanCheck						= com.ibm.team.apt.shared.client.plancheck.PlanCheck;
var MediatorForMultiOwners			= com.ibm.team.tempo.shared.client.internal.simulation.CommonNewCodeMediatorForMultiOwners;
var SimpleSchedule					= com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule;
var OwnerScheduledGraph				= com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph;
var ScheduleByOwner					= com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner;
var GraphOptimization				= com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization;
var GraphNode						= com.ibm.team.tempo.shared.client.internal.simulation.GraphNode;
var TriangularEstimate				= com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate;
var MyAbstractWorkItem				= com.ibm.team.tempo.shared.client.internal.simulation.MyAbstractWorkItem;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.tempo.shared.client.internal", "SimulationMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.Tempo", PlanCheck, { //$NON-NLS-1$

	constructor: function(checkDescription, plan) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getFullCheckElements: function() {
		if (true)
			return [ 1 ];
		
		var iterations= this._plan.getIterations();
		if (iterations.length != 1)
			return [];
			
		return dojo.forEach(this._plan.getTeamMembers(), function(teamMember){
			return {
				owner: teamMember,
				iteration: iterations[0]
			};
		});
	},

	getDeltaCheckElements: function(rootDelta) {
		return [];
	},

	getCheckElements: function(planElements) {
		return [];
	},

	checkElement: function(checkElement, progressMonitor) {
//		progressMonitor.beginTask(bind(Messages['plan_monitorOwnerSimulation'], [checkElement.owner.label]), 1); //$NON-NLS-1$
		progressMonitor.beginTask(bind(Messages['plan_monitorOwnerSimulation'], [""]), 1); //$NON-NLS-1$ //$NON-NLS-2$
		
		var myWorkItems= 	[{
			id:"1", //$NON-NLS-1$
			blocks:["3"], //$NON-NLS-1$
			uuid:"", //$NON-NLS-1$
			ownerUserId:"Bob", //$NON-NLS-1$
			state:"Closed", //$NON-NLS-1$
			priority:"", //$NON-NLS-1$
			lowerEstimate:8, 
			nominalEstimate:9, 
			upperEstimate:12, 
			summary:"(A) Define APIs for each subsystem" //$NON-NLS-1$
		}, {
			id:"4", //$NON-NLS-1$
			blocks:["5"], //$NON-NLS-1$
			uuid:"", //$NON-NLS-1$
			ownerUserId:"Paul", //$NON-NLS-1$
			state:"Closed", //$NON-NLS-1$
			priority:"", //$NON-NLS-1$
			lowerEstimate:5, 
			nominalEstimate:8, 
			upperEstimate:10, 
			summary:"(D) Implement small subset of APIs" //$NON-NLS-1$
		}, {
			id:"5", //$NON-NLS-1$
			uuid:"", //$NON-NLS-1$
			ownerUserId:"Paul", //$NON-NLS-1$
			state:"In Progress", //$NON-NLS-1$
			priority:"", //$NON-NLS-1$
			lowerEstimate:3, 
			nominalEstimate:5, 
			upperEstimate:8, 
			summary:"(E) Implement simple interface stub for calendar" //$NON-NLS-1$
		}, {
			id:"2", //$NON-NLS-1$
			blocks:["3"], //$NON-NLS-1$
			uuid:"", //$NON-NLS-1$
			ownerUserId:"Bob", //$NON-NLS-1$
			state:"Closed", //$NON-NLS-1$
			priority:"", //$NON-NLS-1$
			lowerEstimate:8, 
			nominalEstimate:9, 
			upperEstimate:20, 
			summary:"(B) Identify candidate reusable components for scheduler subsystem" //$NON-NLS-1$
		}, {
			id:"3", //$NON-NLS-1$ 
			uuid:"", //$NON-NLS-1$
			ownerUserId:"Joe", //$NON-NLS-1$
			state:"New", //$NON-NLS-1$
			priority:"", //$NON-NLS-1$
			lowerEstimate:2, 
			nominalEstimate:4, 
			upperEstimate:20, 
			summary:"(C) Implement scheduler subsystem that looks until it finds one feasible solution (brute force if needed)" //$NON-NLS-1$
		}];
		var mediator = new MediatorForMultiOwners(myWorkItems);
		mediator.setDeadline(30, "days"); //$NON-NLS-1$
		// var a = mediator.computeEstimationOutput();
		
		// compute the schedule and run it through monte carlo algo
		var graph = mediator.createGraph(myWorkItems);
		
//		console.log("Input Graph"); //$NON-NLS-1$
//		console.log("-----------"); //$NON-NLS-1$
//		console.log(graph);
		
		// var scheduleGenerator = StatisticsUtil.runParallelSchedulingAlgo(graph);
		
		// run the sequential algorithm among all tasks
		var simpleSchedule = new SimpleSchedule(graph);
		var sequentialSchedule = simpleSchedule.run();  // A dependency-aware sort of the tasks in the order of decreasing risk.
		
//		console.log("Optimized Task List"); //$NON-NLS-1$
//		console.log("-------------------"); //$NON-NLS-1$
		for (var i=0; i < sequentialSchedule.length; i++) {
			var node = sequentialSchedule[i];
//			console.log(node+" impact="+node.getImpact()); //$NON-NLS-1$
		}
		
		// use that order to determine the order within each user 
		var ownerScheduledGraph = new OwnerScheduledGraph(sequentialSchedule);
		var scheduleGenerator = new ScheduleByOwner(ownerScheduledGraph);
		scheduleGenerator.run();
		
		// var monteCarloResults = StatisticsUtil.runMonteCarloAlgo(scheduleGenerator, this.deadline);
		var nIterations = 1000;
		var iterationDays = 30;
		var graphOptimization = new GraphOptimization(scheduleGenerator, iterationDays);
		var monteCarloResults = null;
		try {
			var start = new Date().getTime();
			monteCarloResults = graphOptimization.simulate(nIterations, progressMonitor.child(1));
			var stop = new Date().getTime();
			var timeDiff = (stop-start) / 1000;
//			console.log("\nnIterations="+nIterations+" duration="+timeDiff.toFixed(2)+" seconds\n\n"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch(e) {
//			console.log("%s", e); //$NON-NLS-1$
		}
		
		if (monteCarloResults) {
			monteCarloResults.showMonteCarloNodes();
//			console.log(monteCarloResults.toString()); // Suppressed 4/19/2009
		}
		
//		console.log("%s", monteCarloResults.showMonteCarloNodes()); //$NON-NLS-1$
//		console.log(monteCarloResults);
			
		return null;
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__createNode: function(name, est, owner, ac) {
		var node = new GraphNode(name, est);
		node.setOwner(owner);
		node.setActualCost(ac);
		return(node);
	},

	__createDefaultNodes: function() {
		var graphNodeLst = [];
		
		graphNodeLst.push(this.__createNode("A", new TriangularEstimate( 8,  9,  12), "Bob",  -1)); //$NON-NLS-1$ //$NON-NLS-2$
		graphNodeLst.push(this.__createNode("B", new TriangularEstimate( 8,  9,  20), "Bob",  -1)); //$NON-NLS-1$ //$NON-NLS-2$
		graphNodeLst.push(this.__createNode("C", new TriangularEstimate( 2,  4,  20), "Joe",  -1)); //$NON-NLS-1$ //$NON-NLS-2$
		graphNodeLst.push(this.__createNode("D", new TriangularEstimate( 5,  8,  10), "Paul", -1)); //$NON-NLS-1$ //$NON-NLS-2$
		graphNodeLst.push(this.__createNode("E", new TriangularEstimate( 3,  5,   8), "Paul", -1)); //$NON-NLS-1$ //$NON-NLS-2$
	
		return graphNodeLst;
	},
	
	__createWorkItem: function(id, lower, nominal, upper, owner, blocks) {
		var workItem = new MyAbstractWorkItem();
		workItem.setId(id);
		workItem.setLowerEstimate(lower);
		workItem.setNominalEstimate(nominal);
		workItem.setUpperEstimate(upper);
		workItem.setOwnerUserId(owner);
		if (blocks && blocks.length > 0) {
			workItem.setBlocks(blocks);
		}
		
		return workItem;
	},

	__sentinel: null // terminates this class definition
});

})();
