/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.StatisticsUtil"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization"); //$NON-NLS-1$

(function() {
	
var OwnerScheduledGraph				= com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph;
var ScheduleByOwner					= com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner;
var SimpleSchedule					= com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule;
var GraphOptimization				= com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization;

dojo.mixin(com.ibm.team.tempo.shared.client.internal.simulation.StatisticsUtil, {

	/**
	 * Return a schedule generator that gives schedules taking into account the owners of the tasks
	 */
	runParallelSchedulingAlgo: function (graph) {
		// run the sequential algorithm among all tasks
		var listOfNodesWithGivenOrder = this.runSequentialSchedulingAlgo(graph).getScheduleResult();
		
		// use that order to determine the order within each user 
		var ownerScheduledGraph = new OwnerScheduledGraph(listOfNodesWithGivenOrder);		
		var scheduleGenerator = new ScheduleByOwner(ownerScheduledGraph);
		scheduleGenerator.run();
		return scheduleGenerator;
	},

	/**
	 * Return a schedule generator that gives schedules with in total ordering of tasks, 
	 * based on a dependency-aware sort of the tasks in the order of decreasing risk.
	 */
	runSequentialSchedulingAlgo: function (graph) {
		var simpleSchedule = new SimpleSchedule(graph);
		var sequentialSchedule = simpleSchedule.run();  // A dependency-aware sort of the tasks in the order of decreasing risk.
		return simpleSchedule;
	},

	/**
	 * Run Monte Carlo algorithm to the given a schedule and iteration duration.  The results consist
	 * of probability of completion and predicted estimate to complete each task.
	 */
	runMonteCarloAlgo: function (schedule, iterationDays) {
		var graphOptimization = new GraphOptimization(schedule, iterationDays);
		var results = null;
		try {
			var N = 10000;
			results = graphOptimization.simulate(N);
		} catch(e) {
		}
		return results;
	},

	 __sentinel: null // terminates this class definition
});

})();

