/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ImpactFunc"); //$NON-NLS-1$

(function() {
	
var ImpactFunc						= com.ibm.team.tempo.shared.client.internal.simulation.ImpactFunc;


dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule", null, { //$NON-NLS-1$

	constructor: function(graph) {
		this.resultNodeLst = null;
		this.graph = graph;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	/**
	 * @return A dependency-aware sort of the tasks in the order of decreasing risk.
	 * The graph nodes dependencies have been updated to now reflect the sequential order.
	 *          
	 * @throws MalformedCostException
	 * @throws MalformedGraphException
	 * @throws MalformedScheduleException
	 */
	run: function() { //throws MalformedCostException, MalformedGraphException, MalformedScheduleException
		this.resultNodeLst = [];
		var sortednodes = {}; // 
		var nodelist = [];
		
		var graphNodeTbl= this.graph.getGraphNodeTbl();
		
		this.graph.buildHeadNodeLst();
		this.graph.resetNodes();
		this.graph.initPredecessorCount();
		this.graph.initUnproccessedPredecessorCount();
		
		var headNodes = this.graph.getHeadNodes();
		var node;
		for (var i=0; i < headNodes.length; i++) {
			node = headNodes[i];
			this.updateImpact(sortednodes, graphNodeTbl, node);
		}
		
		var impactArray = [];
		for (var impact in sortednodes) {
			impactArray[impactArray.length] = impact-0;
		}
		
		impactArray.sort(function(e1, e2) {
			var v1 = e1-0;
			var v2 = e2-0;
			if (e1 < e2)
				return -1;
			else if (e1 > e2)
				return 1;
			return 0;
		});
		
		var successor;	
		while (impactArray.length > 0) {
			var lastKey =  impactArray[impactArray.length-1];
			nodelist = sortednodes[lastKey+'']; //$NON-NLS-1$
			delete sortednodes[lastKey];
			//node.currentcost += cost;
			//System.out.println("node=  "+node.index+"  cost=  "+cost+"  currentcost=  "+node.currentcost); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			for (var n=0; n < nodelist.length; n++) {
				node = nodelist[n];			
				if (node.getSuccessors().length > 0) {
					
					var successors = node.getSuccessors();
					for (var s=0; s < successors.length; s++) {
						successor = graphNodeTbl[successors[s]];
						successor.decrementUnprocessedPredecessors();
						
						if (successor.getUnprocessedPredecessors() == 0) 
							this.updateImpact(sortednodes, graphNodeTbl, successor);
					}
				}
				
				this.resultNodeLst.push(node);
			}
			
			impactArray = [];	
			for (var impact in sortednodes) {
				impactArray[impactArray.length] = impact-0;
			}
			
			impactArray.sort(function(e1, e2) {
				var v1 = e1-0;
				var v2 = e2-0;
				if (e1 < e2)
					return -1;
				else if (e1 > e2)
					return 1;
				return 0;
			});
		}
		
		return this.resultNodeLst;
	},
	
	getGraph: function() {
		return this.graph;
	},
	
	getScheduleResult: function() {
		return this.resultNodeLst;
	},
	
	updateImpact: function(bag, graphNodeTbl, graphNode) { //throws MalformedCostException
		var isImpact2On = false;
		
		var estimate = graphNode.getEstimate();
		if (isImpact2On) 
			graphNode.setImpact(ImpactFunc.computeImpact2(graphNode, graphNodeTbl));
		else {
			var impactDbl = ImpactFunc.getValue(estimate.getPd());
			graphNode.setImpact(impactDbl);
		}
		
		this.insertIntoBag(bag, graphNode);
	},
	
 // Inserts nodes into a bag, used by scheduler method to keep a bag of nodes, sorted by impact
	insertIntoBag: function(bag, graphNode) {
		var list;
		var impactKey = graphNode.getImpact()+''; //$NON-NLS-1$
		if (bag[impactKey]) {
			list = bag[impactKey];		
		} else {
			list = [];
		}
		list.push(graphNode);
		bag[impactKey] = list;
	},
	
	updateDependencies: function(scheduleResult) { //throws MalformedGraphException
		for (var i=0; i < scheduleResult.length; i++) {
			var graphNode = scheduleResult[i];
			graphNode.getSuccessors().clear();
			if (i < scheduleResult.length-1)
				graphNode.addSuccessor(scheduleResult[i+1].getId());
		}	
		
		return scheduleResult;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

