/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ImpactFunc"); //$NON-NLS-1$

(function() {
	
var SimpleSchedule				= com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule;
var ImpactFunc					= com.ibm.team.tempo.shared.client.internal.simulation.ImpactFunc;

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner", null, { //$NON-NLS-1$

	constructor: function(ownerScheduledGraph) {
		this.ownerScheduledGraph = ownerScheduledGraph;
		this.scheduleResult = null;
		this.graph = null;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	run: function() {
		this.enforceDependencyOrder(this.ownerScheduledGraph.getGraphNodeLst(), this.ownerScheduledGraph.getOwnerGraphNodeTbl());
		var simpleSchedule2 = new SimpleSchedule(this.ownerScheduledGraph);
		this.scheduleResult = simpleSchedule2.run();
	},
	
	load: function() {
		this.scheduleResult= [];
		ownerNodeTbl = this.ownerScheduledGraph.getOwnerGraphNodeTbl(); 
		
		for (var ownerId in ownerNodeTbl) {
			var ownerNodes = ownerNodeTbl[ownerId];
			
			for (var j = 0; j < ownerNodes.length; j++) {
				var graphNode = ownerNodes[j];
				this.scheduleResult.push(graphNode);
				this.populateImpact(graphNode);
			}
		}
	},
	
	getScheduleResult: function() {
		return this.scheduleResult;
	},
	
	getGraph: function() {
		return this.ownerScheduledGraph;
	},
	
	enforceDependencyOrder: function(orderedGraphNodeLst, ownerGraphNodeTbl) {
		var graphNode, j;
		var graphNodeArr= []; 
	
		for (var ownerId in ownerGraphNodeTbl) {
			var ownerNodeLst = ownerGraphNodeTbl[ownerId];
			
			
			for (j = 0; j < ownerNodeLst.length; j++) {
				graphNode = ownerNodeLst[j];
				var index = orderedGraphNodeLst.indexOf(graphNode);
				
				graphNodeArr[index] = graphNode;
			}
			
			var orderedOwnerNodeLst = [];
			for (j = 0; j < graphNodeArr.length; j++) {
				graphNode = graphNodeArr[j];
				if (graphNode != null) { 
					orderedOwnerNodeLst.push(graphNode);
					graphNodeArr[j] =  null;
				}
			}
			
			ownerGraphNodeTbl[ownerId]= orderedOwnerNodeLst;
		}
	},
	
	populateImpact: function(graphNode) {
		var isImpact2On = false;
		var estimate = graphNode.getEstimate();
		if (isImpact2On) 
			graphNode.setImpact(ImpactFunc.computeImpact2(graphNode, this.graph.getGraphNodeTbl()));
		else {
			var impactDbl = ImpactFunc.getValue(estimate.getPd());
			graphNode.setImpact(impactDbl);
		}
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

