/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.ProbabilityDistribution"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.ProbabilityDistribution", null, { //$NON-NLS-1$

	name: "Probability Distribution", //$NON-NLS-1$
	
	constructor: function() {
		this.lowerbound = 0.0;
		this.middle = 0.0;
		this.upperbound = 0.0;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getName: function() {
		return this.name; 
	},
	
	getLowerbound: function() {
		return this.lowerbound; 
	},
	
	getMiddle: function() {
		return this.middle; 
	},
	
	getUpperbound: function() {
		return this.upperbound; 
	},
	
	randomCost: function(rand) {
		return 0.0;
	},
	
	scale: function(r) {
		return null;
	},
	
	toString: function() {
		var buf = this.getName();
		buf += this.getLowerbound();
		buf += "    "; //$NON-NLS-1$
		buf += this.getMiddle();
		buf += "    "; //$NON-NLS-1$
		buf += this.getUpperbound();
		
		return buf;
	},
	
	equals: function(o){
		if (this == other) 
			return true;
		if (this.declaredClass != other.declaredClass)
			return false;

		return ((this.lowerbound == o.getLowerbound())&&
				(this.middle == o.getMiddle())&&
				(this.upperbound == o.getUpperbound()));
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

