/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.PlanItemSimulation"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.common.ProgressMonitor"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.plancheck.PlanCheck"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.ProbabilityAttribute"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ItemSequenceManagerMediator"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.MyAbstractWorkItem"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.tempo.shared.client.internal", "SimulationMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var ProgressMonitor					= com.ibm.team.apt.common.ProgressMonitor;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanCheck						= com.ibm.team.apt.shared.client.plancheck.PlanCheck;
var Run								= com.ibm.team.apt.shared.client.plancheck.PlanCheck.Run;
var ProbabilityAttribute			= com.ibm.team.tempo.shared.client.ProbabilityAttribute;
var ItemSequenceManagerMediator		= com.ibm.team.tempo.shared.client.internal.simulation.ItemSequenceManagerMediator;
var SimpleSchedule					= com.ibm.team.tempo.shared.client.internal.simulation.SimpleSchedule;
var OwnerScheduledGraph				= com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph;
var ScheduleByOwner					= com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner;
var GraphOptimization				= com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization;
var GraphNode						= com.ibm.team.tempo.shared.client.internal.simulation.GraphNode;
var TriangularEstimate				= com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate;
var MyAbstractWorkItem				= com.ibm.team.tempo.shared.client.internal.simulation.MyAbstractWorkItem;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.tempo.shared.client.internal", "SimulationMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.PlanItemSimulation", PlanCheck, { //$NON-NLS-1$

	constructor: function(checkDescription, plan) {
		this.__probabilityAttribute= plan.findAttribute(ProbabilityAttribute.ID);
		this.__iterations= 1000; //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getFullCheckElements: function() {
//		var iterations= this._plan.getIterations();
//		if (iterations.length != 1)
//			return [];
		
		var result= [];
		dojo.forEach(this._plan.getTeamMembers(), function(teamMember){
			if (this._plan.getItemSequenceManager(teamMember)) {
				result.push({
					owner: teamMember,
					iteration: null
				});
			}
		}, this);
		
		// clear tempo simulation results for all items first when running the simulation
		this._plan.compoundChange(function(builder) {
			var attrImpl= this.__probabilityAttribute.getImplementation();
			this._plan.accept(function(planItem) {
				if (planItem instanceof PlanItem) {
					attrImpl.clearValue(planItem);
				}
				return true;
			}, this);
		}, this);
		
		return result;
	},

	getDeltaCheckElements: function(rootDelta) {
		this._plan.compoundChange(function(builder) {
			var attrImpl= this.__probabilityAttribute.getImplementation();
			rootDelta.accept(function(delta) {
				var planElement= delta.getPlanElement();
				// clear tempo simulation data for resolved items
				if (planElement instanceof PlanItem && delta.affectsAttribute(PlanItem.RESOLVED)) {
					attrImpl.clearValue(planElement);
				}
				return true;
			}, this);
		}, this);
		return [];
	},

	getCheckElements: function(planElements) {
		return [];
	},

	checkElement: function(checkElement, progressMonitor) {
		progressMonitor.beginTask(bind(Messages['plan_monitorOwnerSimulation'], [checkElement.owner.getLabel()]), 1); //$NON-NLS-1$

		var mediator = new ItemSequenceManagerMediator(this._plan, checkElement.owner);  // I was not getting the workitems for an owner
		//var mediator = new ItemSequenceManagerMediator(this._plan, this._plan.getTeamMembers()[0]);  // apparently if I just get the first team member it worked

		var graph = mediator.createGraph();
		
		// run the sequential algorithm among all tasks
//		var simpleSchedule = new SimpleSchedule(graph);
//		var sequentialSchedule = simpleSchedule.run();  // A dependency-aware sort of the tasks in the order of decreasing risk.
		
//		console.log("Optimized Task List"); //$NON-NLS-1$
//		console.log("-------------------"); //$NON-NLS-1$
//		for (var i=0; i < sequentialSchedule.length; i++) {
//			var node = sequentialSchedule[i];
//			console.log(node+" impact="+node.getImpact()); //$NON-NLS-1$
//		}
		
		// use that order to determine the order within each user 
//		var ownerScheduledGraph = new OwnerScheduledGraph(sequentialSchedule);
		var ownerScheduledGraph = new OwnerScheduledGraph(graph.getOrigNodeLst());
		var scheduleGenerator = new ScheduleByOwner(ownerScheduledGraph);
		//scheduleGenerator.run();
		scheduleGenerator.load();
		
		// var monteCarloResults = StatisticsUtil.runMonteCarloAlgo(scheduleGenerator, this.deadline);
		var graphOptimization = new GraphOptimization(scheduleGenerator, mediator.getDeadline());
		var start = new Date().getTime();
		
		var simulationRunner= graphOptimization.simulate(this.__iterations, progressMonitor.child(1, ProgressMonitor.LABEL_NONE));
		return new Run(dojo.hitch(this, function() {
			var executionState= simulationRunner.execute();
			if (executionState == Run.DONE && !progressMonitor.isCanceled()) {
				var monteCarloResults= simulationRunner.getResult();
				var stop = new Date().getTime();
				var timeDiff = (stop-start) / 1000;
//				console.log("nIterations=%s duration=%s seconds", String(nIterations), String(timeDiff.toFixed(2))); //$NON-NLS-1$ // Suppressed 4/19/2009
				
//				console.log("%s", monteCarloResults.showMonteCarloNodes()); //$NON-NLS-1$ // Suppressed 4/19/2009
				
				this._plan.compoundChange(function(builder) {
					var tbl= monteCarloResults.getMonteCarloNodeTbl();
					for (var planItemId in tbl) {
						var planItem= this._plan.getPlanItem(planItemId);
						
						if (planItem) {
							//var newValue= tbl[planItemId].getProbabilityToComplete();  // This number is relative to the plan deadline
							//var completionTime = tbl[planItemId].getCumulativeCostAt(0.95); // This number is the task completion time at 95 percentile
							//var avgCompletionTime = tbl[planItemId].getAvgCumulativeCost(); // This number is the avg task completion time
							
							var newValue= tbl[planItemId].getEffectiveProbabilityToComplete();  // This number is relative to the task deadline
							planItem.setAttributeValue(this.__probabilityAttribute, newValue);
						}
					}
				}, this);
			}

			return executionState;
		}));
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
