/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.Graph"); //$NON-NLS-1$

(function() {
	
var Graph							= com.ibm.team.tempo.shared.client.internal.simulation.Graph;

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph", Graph, { //$NON-NLS-1$

	constructor: function(graphNodeLst) {
		this.ownerGraphNodeTbl= {};
		this.graphNodeLst= graphNodeLst;
		
		this.buildOwnerGraphNodeTbl(this.graphNodeLst);
		
		for (var i = 0; i < this.graphNodeLst.length; i++) {
			var graphNode = this.graphNodeLst[i];
			graphNode.clearPredecessors();

			this.add(graphNode);
		}
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getOwnerGraphNodeTbl: function () {
		return this.ownerGraphNodeTbl;
	},
	
	run: function() {
		this.run_graph(this.getOwnerGraphNodeTbl());
	},
	
	getGraphNodeLst: function() {
		return this.graphNodeLst;
	},

	buildOwnerGraphNodeTbl: function(graphNodeLst) {
		for (var i = 0; i < graphNodeLst.length; i++) {
			var graphNode = graphNodeLst[i];
			if (graphNode.getOwner() == null) {
				graphNode.setOwner("Unknown"); //$NON-NLS-1$
			}
			
			if (this.ownerGraphNodeTbl[graphNode.getOwner()] != null) { 
				this.ownerGraphNodeTbl[graphNode.getOwner()].push(graphNode);
			} else {
				var ownerNodeLst= [];
				ownerNodeLst.push(graphNode);
				this.ownerGraphNodeTbl[graphNode.getOwner()]= ownerNodeLst;
			}
		}
		
		this.buildResourceDependencies();
	},
	
	buildResourceDependencies: function() {
		for (var key in this.ownerGraphNodeTbl) {
			var prevGraphNode = null;
			var ownerNodeLst = this.ownerGraphNodeTbl[key];
			
			for (var j = 0; j < ownerNodeLst.length; j++) {
				var graphNode = ownerNodeLst[j];
				var graphNodeId = graphNode.getId();
				
				var isSuccessor= prevGraphNode != null && !dojo.some(prevGraphNode.getSuccessors(), function(successorKey) {
					return successorKey == graphNodeId;
				});

				if (isSuccessor) { 
					prevGraphNode.addSuccessor(graphNodeId);
				}
	
				prevGraphNode = graphNode;
			}
		}
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

