/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.OwnerNodeListUtil"); //$NON-NLS-1$

(function() {

dojo.mixin(com.ibm.team.tempo.shared.client.internal.simulation.OwnerNodeListUtil, {

	getNextFreeNode: function(graphNode, ownerNodeList) {
		var nextFreeNode = null;
		if (graphNode.getSlack() > 0) {
			var index = dojo.indexOf(ownerNodeList, graphNode);
			for (var i = index +1; i < ownerNodeList.length; i++) {
				var nextOwnerNode = ownerNodeList[i];
				if (nextOwnerNode.getUnprocessedPredecessors() <= 0) {
					nextFreeNode = nextOwnerNode;
					break;
				}
			}
		}
		
		return nextFreeNode;
	},
	
	getPreviousOwnerNode: function(graphNode, ownerNodeList) {
		var previousOwnerNode = null;
		if (graphNode != null) {
			var index = dojo.indexOf(ownerNodeList, graphNode);
			if (index > 0) {
				previousOwnerNode = ownerNodeList[index -1];
			}
		}
		
		return previousOwnerNode;
	},
	
	getNextOwnerNode: function(graphNode, ownerNodeList) {
		var nextOwnerNode = null;
		if (graphNode != null) {
			var index = dojo.indexOf(ownerNodeList, graphNode);
			if (index < ownerNodeList.length) {
				nextOwnerNode = ownerNodeList[index +1];
			}
		}
		
		return (nextOwnerNode);
	},

	__sentinel: null // terminates this class definition
});

})();
