/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.OptimizationResults"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.CostDistributionRpt"); //$NON-NLS-1$

(function() {
	
var CostDistributionRpt				= com.ibm.team.tempo.shared.client.internal.simulation.CostDistributionRpt;

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.OptimizationResults", null, { //$NON-NLS-1$

	constructor: function(costDistribution, lookupCount) {
		this.monteCarloNodeTbl = null;
		this.probabilityToComplete = 0.0;
		
		this.costDistribution = costDistribution;
		this.lookupCount = lookupCount;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	/**
	 * Returns a table that maps a Work Item ID to a MonteCarlo node
	 */
	getMonteCarloNodeTbl: function() {
		return this.monteCarloNodeTbl;
	},

	setMonteCarloNodeTbl: function(monteCarloNodeTbl) {
		this.monteCarloNodeTbl = monteCarloNodeTbl;
	},

	getCostDistribution: function() {
		return this.costDistribution;
	},

	getLookupCount: function() {
		return this.lookupCount;
	},
	
	getProbabilityToComplete: function() {
		return this.probabilityToComplete;
	},

	setProbabilityToComplete: function(probabilityToComplete) {
		this.probabilityToComplete = probabilityToComplete;
	},

	getNodeResults: function(graphNode) {
		return this.getMonteCarloNodeTbl[graphNode.getId()];
	},
	
	showMonteCarloNodes: function() {
		var str = ''; //$NON-NLS-1$
		var msg = ''; //$NON-NLS-1$
		var monteCarloNodeTbl = this.getMonteCarloNodeTbl();
//		console.log(msg = "Monte Carlo Graph Nodes:"); //$NON-NLS-1$ // Suppressed 4/19/2009
		str += msg+'\n'; //$NON-NLS-1$
		for (var id in monteCarloNodeTbl) {
//			console.log(msg = monteCarloNodeTbl[id].showResults()); // Suppressed 4/19/2009
			str += msg+'\n'; //$NON-NLS-1$
		}
		return str;
	},

	toString: function() {
		var buf = ""; //$NON-NLS-1$
		
		try {
			var rpt = new CostDistributionRpt(this.costDistribution);
			rpt.run();
			buf += rpt.getRptText();
		} catch (e) {
		}
		
		buf += "\n\n lookups=" + this.getLookupCount(); //$NON-NLS-1$ 
		buf += " probToComplete=" + this.getProbabilityToComplete(); //$NON-NLS-1$
		return buf;
	},
	
	equals: function(other){
		if (this == other) 
			return true;
		if (this.declaredClass != other.declaredClass)
			return false;
		
		return ((this.getCostDistribution() == other.getCostDistribution())&& (this.getLookupCount() == other.getLookupCount()));
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();
