/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.NbTraverser"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.Traverser"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.OwnerNodeListUtil"); //$NON-NLS-1$

(function() {
	
var Traverser						= com.ibm.team.tempo.shared.client.internal.simulation.Traverser;
var OwnerNodeListUtil				= com.ibm.team.tempo.shared.client.internal.simulation.OwnerNodeListUtil;

/**
 * The Node Back traverse processes all the predecessors of a node, before it goes to
 * the next successor.
 * @author rmd
 *
 */
dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.NbTraverser", Traverser, { //$NON-NLS-1$

	constructor: function() {
		this.ownerNodeTbl = null;
		this.graphNodeTbl = null;
		this.criticalPathTailNode = null;
//		this.headNode = null;
		this.lookupCount = 0;
		this.cost = 0.0;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	run: function(graph, ownerNodeTbl) { 
		this.ownerNodeTbl = ownerNodeTbl;
		this.graphNodeTbl = graph.getGraphNodeTbl();
		this.cost = 0.0;
		this.lookupCount=0;
		
		this.initHeadNodeCostFields(graph);
	    graph.initUnproccessedPredecessorCount();
	    
		var headNodes = graph.getHeadNodes();
		for (var i = 0; i < headNodes.length; i++) {
			var headNode = headNodes[i];
			this.processNode(headNode);
		}			
	},
	
	getCriticalPathTailNode: function() {
		return this.criticalPathTailNode;
	},

	getCost: function() {
		return this.cost;
	},

	/* 
	 * Return the number of times a node was looked up. This is used to judge the 
	 * efficiency of the traversing.
	 */
	getLookupCount: function() {
		return this.lookupCount;
	},

	getOwnerNodeTbl: function() {
		return this.ownerNodeTbl;
	},

	setCriticalPathTailNode: function(criticalPathTailNode) {
		this.criticalPathTailNode = criticalPathTailNode;
	},

	getGraphNodeTbl: function() {
		return this.graphNodeTbl;
	},

	processNode: function(graphNode) {		
		var ownerNodeLst = null;

		if (this.ownerNodeTbl != null) {
			ownerNodeLst = this.ownerNodeTbl[graphNode.getOwner()];
			this.lookupCount++;
			this.computeSlack(graphNode, OwnerNodeListUtil.getPreviousOwnerNode(graphNode, ownerNodeLst));
		}
			
		if (true) {
//		if (sysProperties.isBatchSchedOptimizeOn()) 
			this.batchOptimization(graphNode, ownerNodeLst);
		}
		
		var successors = graphNode.getSuccessors();
		for (var i = 0; i < successors.length; i++) {
			var successorId = successors[i];
			var successor = this.graphNodeTbl[successorId];
			graphNode.setProcessedNode(true);
			this.lookupCount++;
			
			if (successor.getUnprocessedPredecessors() > 0) {
				this.computeCumulativeCost(successor);
				this.processNode(successor);
			}
		}
		
		if (graphNode.getSuccessors().length == 0) {
			this.updateTotal(graphNode);
		}
	},
	
	computeCumulativeCost: function(graphNode) {		
//System.out.println(graphNode.getId() + "  preds = " + graphNode.getNrOfPredecessors() + " Unprocess = " + graphNode.getUnprocessedPredecessors()); //$NON-NLS-1$ //$NON-NLS-2$
		if (graphNode.isProcessedNode() == false && graphNode.getNrOfPredecessors() > 0) {
			var predecessors = graphNode.getPredecessors();
			for (var i = 0; i < predecessors.length; i++) {
				this.lookupCount++;
				var predecessor = predecessors[i];
				
//				if (graphNode.getUnprocessedPredecessors() == 0 )
//					throw new MalformedGraphException("Error: Cyclic condition detected at node " + graphNode); //$NON-NLS-1$
				graphNode.decrementUnprocessedPredecessors();		
				
				var predecessorCumulativeCost = this.computeCumulativeCost(predecessor);
				var cumulativeCost = predecessorCumulativeCost + graphNode.getTotalCost();

				if (cumulativeCost > graphNode.getCumulativeCost()) {
					graphNode.setCumulativeCost(cumulativeCost);
					graphNode.setConstraintPredecessor(predecessor);
				}
			}
		}
		graphNode.setProcessedNode(true);
		return graphNode.getCumulativeCost();
	},
	
	initHeadNodeCostFields: function(graph) {
		var headNodes = graph.getHeadNodes();
		for (var i = 0; i < headNodes.length; i++) {
			var headNode = headNodes[i];
			headNode.setCumulativeCost(headNode.getTotalCost());
		}			
	},
	
	updateTotal: function(graphNode) {
		if (graphNode.getCumulativeCost() > this.cost) {
			this.setCriticalPathTailNode(graphNode);
			this.cost = graphNode.getCumulativeCost();
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

