/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.MyAbstractWorkItem"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.MyAbstractWorkItem", null, { //$NON-NLS-1$

	constructor: function(options) {
		this.estimateChecking = this.NO_TOLERANCE_ON_MISSING_ESTIMATE;
		
		this.blocks = [];
		this.dependsOn = [];
		
		this.optimalPriority = 0;
		this.computedImpact = 0.0;
		
		this.optimalPriorityCategory = 0;	
		this.impactPercentage = 0.0;
		
		this.probabilityOfCompletion = 0.0;
		this.remainingRisk = 0.0;
		this.averageSlack = 0.0;
		this.averageTime = 0.0;
		
		this.estimatesProperty = ""; //$NON-NLS-1$
		this.estimateChecking = 0;
		
		// Added for the web client
		this.lowerEstimate = 0.0;
		this.nominalEstimate = 0.0;
		this.upperEstimate = 0.0;
		this.actual = 0.0;
		
		this.ownerName = ""; //$NON-NLS-1$
		this.ownerUserId = ""; //$NON-NLS-1$
		
		this.id = ""; //$NON-NLS-1$
		this.uuid = null;
		this.priority = ""; //$NON-NLS-1$
		this.state = ""; //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	setOwner: function(contributor) {	},  // probably not needed on the client side
	
	setOwnerUserId: function(ownerUserId) {
		this.ownerUserId = ownerUserId;
	},
	
	getOwnerUserId: function() {
		return this.ownerUserId;
	},
	
	setOwnerName: function(ownerName) {
		this.ownerName = ownerName;
	},
	
	getOwnerName: function() {
		return this.ownerName;
	},
	
	setOptimalPriority: function(priority) {
		this.optimalPriority = priority+1;
	},
	
	getOptimalPriority: function() {
		return this.optimalPriority;
	},
	
	setOptimalPriorityCategory: function(priority) {
		this.optimalPriorityCategory = priority;
	},
	
	getOptimalPriorityCategory: function() {
		return this.optimalPriorityCategory;
	},
	
	setType: function(type) {
		// do nothing
	},
	
	addChild: function(wi) {
		// do nothing
	},
	
	setSystemId: function(uuid) {
		this.uuid = uuid;
	},
	
	getSystemId: function() {
		return this.uuid;
	},
	
	setId: function(id) {
		this.id = id;
	},
	
	getId: function() {
		return this.id;
	},

	getSummary: function() {
		return ""; //$NON-NLS-1$
	},
	
	setPriority: function(priority) {
		this.priority = priority;
	},
	
	getPriority: function() {
		return this.priority;
	},
	
	getParents: function() {
		return null;
	},
	
	getChildren: function() {
		return new Array();
	},
	
	getBlocks: function() {
		return this.blocks;
	},
	
	setBlocks: function(blocks) {
		this.blocks = blocks;
	},
	
	getDependsOn: function() {
		return this.dependsOn;
	},
	
	getType: function() {
		return "WorkItem"; //$NON-NLS-1$
	},
	
	getNominalEstimate: function() {
		return this.nominalEstimate;
	},
	
	getLowerEstimate: function() {
		return this.lowerEstimate;
	},
	
	getUpperEstimate: function() {
		return this.upperEstimate;
	},
	
	setNominalEstimate: function(nominalEstimate) {
		this.nominalEstimate = nominalEstimate;
	},
	
	setLowerEstimate: function(lowerEstimate) {
		this.lowerEstimate = lowerEstimate;
	},
	
	setUpperEstimate: function(upperEstimate) {
		this.upperEstimate = upperEstimate;
	},
	
	toString: function() {
		return this.getId();
	},

	getComputedImpact: function() {
		return this.computedImpact;
	},

	setComputedImpact: function(impact) {
		this.computedImpact = impact;		
	},

	getComputedImpactPercentage: function() {
		return this.impactPercentage;
	},

	getComputedProbabilityOfCompletionPercentage: function() {
		return this.probabilityOfCompletion;
	},

	getComputedRemainingRisk: function() {
		return this.remainingRisk;
	},
	
	getComputedAverageSlack: function() {
		return this.averageSlack;
	},
	
	getComputedAverageTime: function() {
		return this.averageTime;
	},
	
	getDeadlineDate: function() {
		return -1;
	},
	
	getDeadlineDuration: function() {
		return -1;
	},
	
	getEstimatesProperty: function() {
		return this.estimatesProperty;
	},
	
	setState: function(state) {
		this.state = state;
	},
	
	getState: function() {
		return this.state;
	},
	
	setComputedImpactPercentage: function(impactPercentage) {
		this.impactPercentage = impactPercentage;		
	},

	setComputedProbabilityOfCompletionPercentage: function(probabilityOfCompletion) {
		this.probabilityOfCompletion = probabilityOfCompletion;
	},

	setComputedRemainingRisk: function(remainingRisk) {
		this.remainingRisk = remainingRisk;
	},
	
	setComputedAverageSlack: function(slack) {
		this.averageSlack = slack;
	},
	
	setComputedAverageTime: function(average) { 
		this.averageTime = average;
	},
	
	setEstimateProperty: function(property) {
		this.estimatesProperty=property;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

