/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.ItemSequenceManagerMediator"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.Graph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ProbabilityDistributionType"); //$NON-NLS-1$

(function() {
	
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var Graph							= com.ibm.team.tempo.shared.client.internal.simulation.Graph;
var GraphNode						= com.ibm.team.tempo.shared.client.internal.simulation.GraphNode;
var TriangularEstimate				= com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate;
var ProbabilityDistributionType		= com.ibm.team.tempo.shared.client.internal.simulation.ProbabilityDistributionType;

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.ItemSequenceManagerMediator", null, { //$NON-NLS-1$

	__deadlineCache: null,
	
	constructor: function(plan, owner) {
		this.__plan= plan;
		this.__owner= owner;
		this.__deadlineCache= {};
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	createGraph: function() {
		var result = new Graph();
		
		var sequenceManager= this.__plan.getItemSequenceManager(this.__owner);
		var scheduledItems= sequenceManager.getScheduledItems();
		
		dojo.forEach(sequenceManager.getScheduledItems(), function(planItem) {
			result.add(this.__createGraphNode(planItem));
		}, this);

		return result;
	},
	
	getDeadline: function() {
		return this.__getDeadline(null);
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__createGraphNode: function(planItem) {

		var minimal= this.__getEstimate(planItem, PlanItem.MINIMAL_ESTIMATE); 
		var nominal= this.__getEstimate(planItem, PlanItem.ESTIMATE);
		var maximal= this.__getEstimate(planItem, PlanItem.MAXIMAL_ESTIMATE);
		
		if (nominal < 0 || minimal < 0 || maximal < 0) {
			if (nominal < 0) {
				if (minimal > 0 || maximal > 0) {
					if (minimal > 0 && maximal > 0) {
						nominal = (minimal+maximal)/2;
					} else if (minimal > 0) {
						nominal = minimal*2;
					} else {
						nominal = maximal/2;
					}
				} else {
					nominal= 0;
				}
			}
			
			if (minimal < 0) {
				minimal = nominal/2;
			}
			
			if (maximal < 0) {
				maximal = nominal*2;
			}
		}
		
		if (minimal > nominal) {
			minimal= nominal;
		}
		
		if (maximal < nominal) {
			maximal= nominal;
		}
	

		var estimate = new TriangularEstimate(minimal, nominal, maximal, ProbabilityDistributionType.TRIANGULAR);
		var result = new GraphNode(planItem.getUuid(), estimate);
	
		var deadline = this.__getDeadline(planItem.getAttributeValue(PlanItem.TARGET));	
		var taskDeadline = deadline;
		
		result.setTargetCost(deadline);
		result.setEffectiveTargetCost(taskDeadline);
		
		console.inspect("", planItem.getAttributeValue(PlanItem.OWNER).getItemId());
		result.setOwner(planItem.getAttributeValue(PlanItem.OWNER).getItemId());

		return result;
	},

	__getEstimate: function(planItem, estimateAttribute) {
		var estimate= planItem.getAttributeValue(estimateAttribute);
		return (estimate != undefined && estimate.specified) ? estimate.getMilliseconds() : -1;
	},

	__getDeadline: function(targetIteration) {
		var cacheKey= (targetIteration && targetIteration.getItemId()) || "null"; //$NON-NLS-1$

		var result= this.__deadlineCache[cacheKey];
		if (result === undefined) {
			result= this.__plan.getItemSequenceManager(this.__owner).getRemainingWorkTime(targetIteration);
			this.__deadlineCache[cacheKey]= result;
		}

		return result;
	},

	
	__sentinel: null // terminates this class definition
});
	
})();
