/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.ImpactFunc"); //$NON-NLS-1$

(function() {

function getVariance(pd) {
	return pd.getUpperbound() - pd.getLowerbound();
}

function getValue(pd) {
	var value = getVariance(pd);
	return value;
}

function computeImpact2(graphNode, graphNodeTbl) {
	var estimate = graphNode.getEstimate();
	var impactDbl;

	if (!graphNode.isRandomVariate()) {
		impactDbl = 0.0;
	} else {
		if (graphNode.getSuccessors().length == 0)
		impactDbl = 0.0;
		else {
			impactDbl = getValue(estimate.getPd());
			var successors = graphNode.getSuccessors();
			for (var i = 0; i < successors.length; i++) {
				var successor = graphNodeTbl[successors[i]];
				var successorImpact = computeImpact2(successor, graphNodeTbl);
				impactDbl = impactDbl + successorImpact / (successors.length - 0.0);
			}
		}
	}
	return impactDbl;
}

dojo.mixin(com.ibm.team.tempo.shared.client.internal.simulation.ImpactFunc, {
	getValue: getValue,
	getVariance: getVariance,
	computeImpact2: computeImpact2
});

})();

