/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.IMyWorkItem"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.IMyWorkItem", null, { //$NON-NLS-1$

	constructor : function(options) {
		this.NO_TOLERANCE_ON_MISSING_ESTIMATE= 1;
		this.INFER_ESTIMATE= 2;

		this.HIGH= 0;
		this.MEDIUM= 1;
		this.LOW= 2;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	/**
	* Universally unique ID of a workitem.
	*/
	getSystemId : function() {
		return null;
	},

	/**
	 * User readable ID of a workItem that is not intended for system use.  
	 * For a universally unique ID, see getSystemId().
	 */
	getId : function() {
		return ""; //$NON-NLS-1$
	},

	/**
	 * Summary of the workitem, in plain textual format
	 */
	getSummary : function() {
		return ""; //$NON-NLS-1$
	},

	/**
	 * A list of workitem IDs (in user readable, but should change to UUIDs)
	 * that this given workitem blocks.
	 */
	getBlocks : function() {
		return null;
	},

	/**
	 * A list of workitem IDs (in user readable, but should change to UUIDs)
	 * that this given workitem depends on.
	 */
	getDependsOn : function() {
		return null;
	},

	/**
	 * The nominal estimated time to complete this work item.  This is provided
	 * by the user in the original work item form.
	 */
	getNominalEstimate : function() {
		return 0.0;
	},

	/**
	 * The lower estimated time to complete this work item.  This is provided by
	 * the user in the estimation enabled work item form.
	 */
	getLowerEstimate : function() {
		return 0.0;
	},

	/**
	 * The upper estimated time to complete this work item.  This is provided by
	 * the user in the estimation enabled work item form.
	 */
	getUpperEstimate : function() {
		return 0.0;
	},

	/**
	 * The priority value set by the user on a work item
	 */
	getPriority : function() {
		return ""; //$NON-NLS-1$
	},

	/**
	 * The optimal priority of this work item determined by the statistical
	 * component.
	 */
	getOptimalPriority : function() {
		return 0;
	},

	/**
	 * The optimal priority of this work item determined by the statistical
	 * component.
	 */
	getOptimalPriorityCategory : function() {
		return null;
	},

	/**
	 * Reference to the corresponding Jazz IWorkItem.
	 */
	getWorkItem : function() {
		return null;
	},

	/**
	 * Impact outputted by Statistics code
	 */
	getComputedImpact : function() {
		return 0.0;
	},

	getComputedImpactPercentage : function() {
		return 0.0;
	},

	getComputedRemainingRisk : function() {
		return 0.0;
	},

	getComputedProbabilityOfCompletionPercentage : function() {
		return 0.0;
	},

	getComputedAverageSlack : function() {
		return 0.0;
	},

	getComputedAverageTime : function() {
		return 0.0;
	},

	getDeadlineDuration : function() {
		return 0;
	},

	getDeadlineDate : function() {
		return 0;
	},

	getEstimatesProperty : function() {
		return ""; //$NON-NLS-1$
	},

	/**
	 * Type of the task, e.g., "Milestone", "Iteration", "WorkItem" 
	 */
	getType : function() {
		return ""; //$NON-NLS-1$
	},

	/**
	 * Name of the person assigned to this work item
	 */
	getOwnerName : function() {
		return ""; //$NON-NLS-1$
	},

	/**
	 * User ID of the person assigned to this work item
	 */
	getOwnerUserId : function() {
		return ""; //$NON-NLS-1$
	},

	getState : function() {
		return ""; //$NON-NLS-1$
	},

	getActual : function() {
		return 0.0;
	},

	setOwner : function(owner) {},

	/**
	 * @see getOptimalPriority() 
	 */
	setOptimalPriority : function(priority) {},

	/**
	 * @see getImpact
	 */
	setComputedImpact : function(impact) {},

	/**
	 * @see getComputedImpactPercentage
	 */
	setComputedImpactPercentage : function(impactPercentage) {},

	/**
	 * @see getComputedRemainingRisk
	 */
	setComputedRemainingRisk : function(remainingRisk) {},

	/**
	 * @see getComputedProbabilityOfCompletionPercentage
	 */
	setComputedProbabilityOfCompletionPercentage : function(probabilityOfCompletion) {},

	/**
	 * @see getComputedAverageSlack
	 */
	setComputedAverageSlack : function(slack) {},

	/**
	 * @see getComputedAverageTime
	 */
	setComputedAverageTime : function(average) {},

	/**
	 * @see getOptimalPriorityCategory() 
	 */
	setOptimalPriorityCategory : function(priority) {},

	setLowerEstimate : function(estimate) {},
	setNominalEstimate : function(estimate) {},
	setUpperEstimate : function(estimate) {},

	/**
	 * @see getType()
	 */
	setType : function(type) {},

	/**
	 * Add a child
	 */
	addChild : function(child) {},

	/**
	 * A list of children elements
	 */
	getChildren : function() {
		return null;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel : null
// terminates this class definition
});

})();

/**
 * A representation of work item  that serves as the API for accessing an
 * IWorkItem from Jazz.
 *  
 */

function IMyWorkItem() {
/**
 * Option for estimate checking
 */

}