/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.GraphNode"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.GraphNode", null, { //$NON-NLS-1$

	constructor: function(id, estimateOrActualCost) {
		this.estimate = null;
		this.startCost= 0.0;
		this.cost = 0.0;
		this.actualCost = 0.0;
		this.cumulativeCost = 0.0;
		this.slack = 0.0;
		this.impact = 0.0;
		this.targetCost = Number.NaN;
		this.effectiveTargetCost = Number.NaN;	
		this.targetCompletionCost = Number.NaN;
	
		this.owner = ""; //$NON-NLS-1$
		this.isRandomVariateFlag = false;
		this.isProcessedNodeFlag = false;
		this.constraintPredecessor = null;
		this.priority = 0;
		this.unprocessedPredecessors = 0;
		this.successors = null; 
		this.predecessors = null; 

		this.id = id;
		
		if (typeof estimateOrActualCost == 'number') { //$NON-NLS-1$
			this.setActualCost(estimateOrActualCost);
		} else {
			this.setEstimate(estimateOrActualCost);
		}

	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getId: function() {
		return this.id;
	},

	getOwner: function() {
		return this.owner;
	},
	
	setOwner: function(owner) {
		this.owner = owner;
	},

	getPriority: function() {
		return this.priority;
	},

	setPriority: function(priority) {
		this.priority = priority;
	},

	isProcessedNode: function() {
		return this.isProcessedNodeFlag;
	},

	setProcessedNode: function(isProcessedNode) {
		this.isProcessedNodeFlag = isProcessedNode;
	},

	getStartCost: function() {
		return this.startCost;
	},

	setStartCost: function(startCost) {
		this.startCost = startCost;
	},
	
	getSlack: function() {
		return this.slack;
	},

	setSlack: function(slackCost) {
		this.slack = slackCost;
	},

	getImpact: function() {
		return this.impact;
	},

	setImpact: function(impact) {
		this.impact = impact;
	},

	getCumulativeCost: function() {
		return this.cumulativeCost;
	},

	setCumulativeCost: function(cumulativeCost) {
		this.cumulativeCost = cumulativeCost;
	},

	/**
	 * @return Cost for just this node.
	 */
	getTargetCost: function() {
		return this.targetCost;
	},

	/**
	 * @param targetCost Cost for just this node.
	 */
	setTargetCost: function(targetCost) {
		this.targetCost = targetCost;
	},
	
	/**
	 * @return Cost for this node plus predecessors and slack.
	 */
	getEffectiveTargetCost: function() {
		return this.effectiveTargetCost;
	},

	/**
	 * @param effecttiveTargetCost Cost for this node plus predecessors and slack.
	 */
	setEffectiveTargetCost: function(effectiveTargetCost) {
		this.effectiveTargetCost = effectiveTargetCost;
	},	
	
	/**
	 * @return Cost for the overall cycle (i.e. iteration).
	 */
	getTargetCompletionCost: function() {
		return this.targetCompletionCost;
	},

	/**
	 * @param targetCompletionCost Cost for the overall cycle (i.e. iteration).
	 */
	setTargetCompletionCost: function(targetCompletionCost) {
		this.targetCompletionCost = targetCompletionCost;
	},

	getConstraintPredecessor: function() {
		return this.constraintPredecessor;
	},
	
	setConstraintPredecessor: function(constraintPredecessor) {
		this.constraintPredecessor = constraintPredecessor;
	},
	
	getCost: function() {
		return this.cost;
	},
	
	getActualCost: function() {
		return this.actualCost;
	},

	setActualCost: function(actualCost) {
		this.actualCost = actualCost;
	},

	getTotalCost: function() {
		return this.getStartCost() + this.getCost();
	},
	
	getUnprocessedPredecessors: function() {
		return this.unprocessedPredecessors;
	},

	setUnprocessedPredecessors: function(unprocessedPredecessors) {
		this.unprocessedPredecessors = unprocessedPredecessors;
	},

	decrementUnprocessedPredecessors: function() {
		this.unprocessedPredecessors--;
	},
	
	addSuccessor: function(successor) {
		if (successor != null)
			this.getSuccessors().push(successor);
	},
	
	getSuccessors: function() {
		if (this.successors == null) {
			this.successors = [];
		}
		return this.successors;
	},

	addPredecessor: function(predecessor) {
		if (predecessor != null)
			this.getPredecessors().push(predecessor);
	},
	
	getPredecessors: function() {
		if (this.predecessors == null) {
			this.predecessors = [];
		}
		return this.predecessors;
	},

	clearPredecessors: function() {
		this.predecessors= null;
	},
	
	getNrOfPredecessors: function() {
		return this.getPredecessors().length;
		//var nrOfPredecessors = 0;
		//if (this.predecessors != null) {
			//nrOfPredecessors = this.getPredecessors().length; 
		//}
		//return nrOfPredecessors;
	},
	
	isRandomVariate: function() {
		return this.isRandomVariateFlag;
	},

	setSuccessors: function(successors) {
		this.successors = successors;
	},
	
	getEstimate: function() {
		return this.estimate;
	},
	
	setEstimate: function(estimate) {
		this.estimate = estimate;
		this.isRandomVariateFlag = estimate.isRandomVariate();		
	},
	
	toString: function() {
		return this.getId();
	},	
	
	show: function(withSlack) {
		var buf = ""; //$NON-NLS-1$
		buf += " Id=" + this.getId(); //$NON-NLS-1$
		buf += " owner=" + this.getOwner(); //$NON-NLS-1$
		buf += " estimate=[" + this.estimate + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		buf += " startCost=" + this.getStartCost(); //$NON-NLS-1$
		buf += " cost=" + Math.round(this.getCost()); //$NON-NLS-1$
		buf += " impact=" + this.impact; //$NON-NLS-1$
		buf += " cumulativeCost=" + Math.round(this.getCumulativeCost()); //$NON-NLS-1$
		if (withSlack) {
			buf += " slack=" + this.getSlack(); //$NON-NLS-1$
		}
		buf += " predecessors=[" + this.getPredecessors() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
		buf += " successors=[" + this.getSuccessors() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
//		console.log(buf); // Suppressed 4/19/2009
		return buf;
//		System.out.println(buf.toString());
	},
	
	reset: function() {
		this.setSlack(0.0);
		this.setCumulativeCost(0.0);
		this.setUnprocessedPredecessors(0);
		this.setProcessedNode(false);
		this.constraintPredecessor = null;
	},
		
	computeCost: function() {
		if (this.actualCost > 0.0) {
			this.cost = this.actualCost;
		} else {
			this.estimate.computeCost();
			this.cost = this.estimate.getCost();
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

