/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.Graph"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.NbTraverser"); //$NON-NLS-1$

(function() {

var NbTraverser						= com.ibm.team.tempo.shared.client.internal.simulation.NbTraverser;

/**
 * Graph - Build the graph.
 * Abort if a successor is not found.
 * @author rmd
 */
dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.Graph", null, { //$NON-NLS-1$

	constructor: function() {
		this.origNodeLst = [];
		this.graphNodeTbl= {};
		this.headNodeLst= [];
		this.successorIdLst= [];
		this.traverser = new NbTraverser();
		this.criticalPathTailNode = null;
		this.isRandomVariate = false;
		this.isSuccessorValidated = false;
		this.critPathTotalCost = 0.0;
		this.lookupCount = 0;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	add: function(graphNodeOrLst) {
		var graphNodeLst = (graphNodeOrLst.length ? graphNodeOrLst : [graphNodeOrLst]);
		for (var i=0; i < graphNodeLst.length; i++) {
			var graphNode = graphNodeLst[i];
			this.graphNodeTbl[graphNode.getId()]= graphNode;
			this.origNodeLst.push(graphNode);
			if (graphNode.isRandomVariate()) {
				this.setRandomVariate(true);
			}

			var successorLst = graphNode.getSuccessors(); 
			if (successorLst != null) {	
				for (var s = 0; s < successorLst.length; s++) {
					var successorId = successorLst[s];
					if (dojo.indexOf(this.successorIdLst, successorId) < 0) {
						this.successorIdLst.push(successorId); 
					}
				}
			}
		}
		
		this.isSuccessorValidated = false;
	},
	
	getOrigNodeLst: function() {
		return this.origNodeLst;
	},
	
	getGraphNodeTbl: function() {
		return this.graphNodeTbl;
	},
	
	getCriticalPath: function() {
		var criticalPathLst= [];
		var criticalPathBackwardLst= [];
		var graphNode = this.criticalPathTailNode;
		while (graphNode != null) {
			criticalPathBackwardLst.push(graphNode);
			graphNode = graphNode.getConstraintPredecessor();
		}

		for (var i = criticalPathBackwardLst.length-1; i == 0 ; i--) {
			criticalPathLst.push(criticalPathBackwardLst[i]);
		}
		
		return criticalPathLst;
	},
	
	getCritPathTotalCost: function() {
		return this.critPathTotalCost;
	},

	isRandomVariate: function() {
		return this.isRandomVariate;
	},
	
	getCriticalPathTailNode: function() {
		return this.criticalPathTailNode;
	},

	/**
	 * Traverse the graph one time. Compute lookup count and critical path data.
	 * @throws MalformedGraphException
	 */
	run: function() {
		this.run_graph(null);
	},

	resetSuccessorValidated: function() {
		this.isSuccessorValidated = false;
	},

	accept: function(traverser) {
		this.traverser = traverser;
	},
	
	getLookupCount: function() {
		return this.lookupCount;
	},

	resetNodes: function() {
		for (var key in this.graphNodeTbl) {
			this.graphNodeTbl[key].reset();
		}
	},
	
	getHeadNodes: function() {	
		return this.headNodeLst;
	},

	buildHeadNodeLst: function() {
		if (this.headNodeLst.length > 0)
			return;
		this.headNodeLst= [];

		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];
			if (dojo.indexOf(this.successorIdLst, graphNode.getId()) < 0) { 
				this.headNodeLst.push(graphNode);
			}
		}
		
		if (this.headNodeLst.length == 0) {
			//throw "Error: Failed to build graph. Either the graph is empty or all nodes are successors."; //$NON-NLS-1$
		}
			
	},
	
	initUnproccessedPredecessorCount: function() {
		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];
			graphNode.setUnprocessedPredecessors(graphNode.getNrOfPredecessors());
		}
	},
	
	initPredecessorCount: function() {
		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];

			var successors = graphNode.getSuccessors();
			for (var j = 0; j < successors.length; j++) {
				var successorId = successors[j];
				var successor = this.graphNodeTbl[successorId]; 
				successor.addPredecessor(graphNode);
			}
		}
	},
	
	show: function() {
		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];
			graphNode.show(this.traverser.getOwnerNodeTbl() != null);
		}
	},
	
	toString: function() {
		var str = ''; //$NON-NLS-1$
		
		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];
			str += graphNode.show(this.traverser.getOwnerNodeTbl() != null)+'\n'; //$NON-NLS-1$
		}
		
		return str;
	},
	
	run_graph: function(ownerGraphNodeTbl) { 
		if (this.isSuccessorValidated == false) {
			this.validateSuccessors();
			this.initPredecessorCount();
		}
		
		this.computeCost();	
		
		this.buildHeadNodeLst();
		this.traverser.run(this, ownerGraphNodeTbl);

		this.setCritPathTotalCost(this.traverser.getCost());
		this.setCritPathTailNode(this.traverser.getCriticalPathTailNode());
		this.setLookupCount(this.traverser.getLookupCount());
	},
	
	computeCost: function() {
		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];
			graphNode.computeCost();
		}
	},
	
	setRandomVariate: function(isRandomVariate) {
		this.isRandomVariate = isRandomVariate;
	},

	setCritPathTotalCost: function(critPathTotalCost) {
		this.critPathTotalCost = critPathTotalCost;
	},
	
	setLookupCount: function(lookupCount) {
		this.lookupCount = lookupCount;
	},

	setCritPathTailNode: function(criticalPathTailNode) {
		this.criticalPathTailNode = criticalPathTailNode;	
	},
	
	/**
	 * validateSuccessors - Validate that the successors are found in the graph.
	 * @throws MalformedGraphException 
	 */
	validateSuccessors: function() {
		for (var key in this.graphNodeTbl) {
			var graphNode= this.graphNodeTbl[key];
			var successors = graphNode.getSuccessors();
			for (var j = 0; j < successors.length; j++) {
				var successorId = successors[j];
				var successor = this.graphNodeTbl[successorId]; 
//				if (getGraphNodeTbl().get(successorId) == null) 
//					throw new MalformedGraphException("Error: The successor " + successorId + " for node " + graphNode.getId() + " is not in the graph."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		
		this.isSuccessorValidated = true;
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

