/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.Estimate"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.Estimate", null, { //$NON-NLS-1$

	constructor: function() {
		this.cost = Number.NaN;
		this.randomVariate = null;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getCost: function() {
		return this.cost;
	},

	computeCost: function() {		
	},

	setCost: function(cost) {		
		this.cost = cost;
	},

	setRandomVariate: function(randomVariate) {		
		this.randomVariate = randomVariate;
	},
	
	isRandomVariate: function() {
		return this.randomVariate;
	},
	
	toString: function() {
		return "cost=" + Math.round(this.getCost()); //$NON-NLS-1$
	},
	
	equals: function(other){
		if (this == other)
			return true;
		if (!(other instanceof com.ibm.team.tempo.shared.client.internal.simulation.Estimate))
			return false;

		return this.getCost() == other.getCost();
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();

