/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.CostDistributionRpt"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ACostDistributionRpt"); //$NON-NLS-1$

(function() {

var ACostDistributionRpt			= com.ibm.team.tempo.shared.client.internal.simulation.ACostDistributionRpt;

/**
 * Cost Distribution Report: Print the distribution summary statistics to the console.
 * This report is only used for testing purposes.
 */
dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.CostDistributionRpt", ACostDistributionRpt, { //$NON-NLS-1$

	constructor: function(dist) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	/**
	 * Print the distribution to the console.
	 */
	run: function () {
		var title = "Cost Distribution Report"; //$NON-NLS-1$
		var midpoint;
		
		this.addHeader(title, "  Count", this.dist.getMaxCount()); //$NON-NLS-1$
		
		for (var i = 0; i < this.dist.getNrOfBins(); i++) {
			midpoint = this.dist.getMidpointStr(i);
			this.addDetail(midpoint, this.dist.getCountOfBin(i), 0);
		}
		
		this.addUnivariateStats();
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();
