/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.CommonNewCodeMediatorForMultiOwners"); //$NON-NLS-1$

dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.StatisticsUtil"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.TriangularDistribution"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.Graph"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.GraphNode"); //$NON-NLS-1$
dojo.require("com.ibm.team.tempo.shared.client.internal.simulation.ProbabilityDistributionType"); //$NON-NLS-1$

(function() {
	
var StatisticsUtil					= com.ibm.team.tempo.shared.client.internal.simulation.StatisticsUtil;
var TriangularDistribution			= com.ibm.team.tempo.shared.client.internal.simulation.TriangularDistribution;
var OwnerScheduledGraph				= com.ibm.team.tempo.shared.client.internal.simulation.OwnerScheduledGraph;
var ScheduleByOwner					= com.ibm.team.tempo.shared.client.internal.simulation.ScheduleByOwner;
var GraphOptimization				= com.ibm.team.tempo.shared.client.internal.simulation.GraphOptimization;
var TriangularEstimate				= com.ibm.team.tempo.shared.client.internal.simulation.TriangularEstimate;
var Graph							= com.ibm.team.tempo.shared.client.internal.simulation.Graph;
var GraphNode						= com.ibm.team.tempo.shared.client.internal.simulation.GraphNode;
var ProbabilityDistributionType		= com.ibm.team.tempo.shared.client.internal.simulation.ProbabilityDistributionType;

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.CommonNewCodeMediatorForMultiOwners", null, { //$NON-NLS-1$

	constructor: function(workItemConsistentGraph) {
		this.monteCarloResults = null;
		this.deadline = -1;
		this.deadlineUnit = ""; //$NON-NLS-1$
		this.totalSlack = 0.0;
	
		this.workItems = workItemConsistentGraph;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getWorkItems: function() {
		return this.workItems;
	},
	
	setWorkItems: function(graph) {
		this.workItems = graph;
	},
	
	getProbabilityToComplete: function() {
		return this.monteCarloResults.getProbabilityToComplete();
	},
	
	getSlack: function() {
		return this.totalSlack;
	},
	
	setDeadline: function(deadline, unit) {
		this.deadline = deadline;
		this.deadlineUnit = unit;
	},
	
	getDeadline: function() {
		return this.deadline;
	},
	
	getDeadlineUnit: function() {
		return this.deadlineUnit;
	},

	computeEstimationOutput: function() {
		try {
			// compute the schedule and run it through monte carlo algo
			
			var graph = this.createGraph(this.workItems);
			
			var scheduleGenerator = StatisticsUtil.runParallelSchedulingAlgo(graph);
			this.monteCarloResults =
				StatisticsUtil.runMonteCarloAlgo(scheduleGenerator, this.deadline);
						
			// sort the schedule by user
			var scheduledNodes = scheduleGenerator.getScheduleResult();
//			Collections.sort(scheduledNodes,getSortByOwnerComparator());
			// populate the results to my data structure
			// var scheduledWorkItems = this.copy(scheduledNodes);
			var scheduledWorkItems = scheduledNodes;
			// this.populatePercentageImpact(scheduledWorkItems);
			// this.populateMonteCarloResults(scheduledNodes, scheduledWorkItems);
			return scheduledWorkItems;
		} catch (e) {
//			console.log(e); // Suppressed 4/19/2009
		} 
		return new Array();
	},
	
	getProbabilityOfCompletionGraph: function() {
		return this.monteCarloResults.getCostDistribution();
	},
	
	getRolledUpValues: function() {
		var td = TriangularDistribution.fromMoments(
				this.monteCarloResults.getCostDistribution().getMoments());
		return td;
	},
	
	computeEstimationOutputGivenSchedule: function(workItemGraph) {
		try {
			this.workItems = workItemGraph;
			// creates graph appropriate for the stats component
			var scheduledNodes = new Array();
			for (var i = 0; i < this.workItems.length; i++) {
				var wi = workItems[i];
				var graphNode = this.createGraphNode(wi);
				scheduledNodes.push(graphNode);
			}
//			Collections.sort(scheduledNodes, getSortByOwnerComparator()); // necessary step for input to OwnerScheduledGraph
			var scheduledGraph = new OwnerScheduledGraph(scheduledNodes);
//			scheduledGraph.show();
			// load the graph to the schedule generator
			var scheduleGenerator = new ScheduleByOwner(scheduledGraph);
			scheduleGenerator.load();

			// perform monte carlo algorithm
			var graphOptimization = new GraphOptimization();
			graphOptimization.initByOwner(scheduleGenerator,  this.deadline);
			var N = 100000;
			this.monteCarloResults = graphOptimization.simulate(N);

			// sort the schedule by user
			scheduledNodes = scheduleGenerator.getScheduleResult();		
//			Collections.sort(scheduledNodes, getSortByOwnerComparator());

			// populate the results to my data structure
			var scheduledWorkItems = this.update(scheduledNodes);
			this.populatePercentageImpact(scheduledWorkItems);
			this.populateMonteCarloResults(scheduledNodes, scheduledWorkItems);
			return scheduledWorkItems;
			//		}
		} catch (e) {
		}
		return new Array();
	},

	copy: function(inputScheduledNodes) {
		var scheduledWorkItems = new Array(inputScheduledNodes.size());
		for (var i = 0; i < inputScheduledNodes.size(); i++ ) {
			var id = inputScheduledNodes[i].getId();
			var wiData = this.workItems.getWorkItemData(id);					
			var optimalPriorityRank = i+1; // make it from 0-based to 1-based
			wiData.setOptimalPriority(optimalPriorityRank);
			wiData.setComputedImpact(inputScheduledNodes[i].getImpact());
			scheduledWorkItems[i] = wiData;
		}
		
		return scheduledWorkItems;		
	},		
	
	update: function(inputScheduledNodes) {
		var wi = new Array(inputScheduledNodes.length);
		for (var i = 0; i < inputScheduledNodes.length; i++ ) {
			var id = inputScheduledNodes[i].getId();
			var wiData = this.workItems.getWorkItemData(id);					
			var optimalPriorityRank = i+1; // make it from 0-based to 1-based
			wiData.setOptimalPriority(optimalPriorityRank);
			wiData.setComputedImpact(inputScheduledNodes[i].getImpact());
			wi.push(wiData);
		}
		
		return wi;		
	},	
	
	populatePercentageImpact: function(inputScheduledWorkItems) {
		var totalimpact = 0.0;
		for (var i = 0; i < inputScheduledWorkItems.length; i++) {
			totalimpact += inputScheduledWorkItems[i].getComputedImpact();
		}
		for (var i =0; i < inputScheduledWorkItems.length; i++) {
			var currentimpact = inputScheduledWorkItems[i].getComputedImpact();
			var percentageImpact = (100.0*currentimpact/totalimpact);
			inputScheduledWorkItems[i].setComputedImpactPercentage(percentageImpact);
			
//			System.out.println(inputScheduledWorkItems[i].toString()+
//					"  impact: " +inputScheduledWorkItems[i].getComputedImpact() + //$NON-NLS-1$
//					"  % impact:  "+ percentageImpact); //$NON-NLS-1$
		}
	},	
	
	populateMonteCarloResults: function(scheduledNodes, scheduledWorkItems) { 
		this.monteCarloResults.showMonteCarloNodes();
		
		for (var i = 0; i < scheduledNodes.length; i++ ) {
			var node = this.monteCarloResults.getNodeResults(scheduledNodes[i]);
			
			scheduledWorkItems[i].setComputedProbabilityOfCompletionPercentage(
					this.deadline == node.getTargetCost()
						? node.getProbabilityToComplete()*100    /* task view */
						: node.getEffectiveProbabilityToComplete()*100   /* project view */
						 
			);
			scheduledWorkItems[i].setComputedAverageSlack(node.getAvgSlack());
			scheduledWorkItems[i].setComputedAverageTime(node.getAvgCost());
//			System.out.println("owner: " + scheduledWorkItems[i].getOwnerUserId() //$NON-NLS-1$
//					+ ", summary: " + scheduledWorkItems[i].getSummary() //$NON-NLS-1$
//						+ ", prob complete: " + scheduledWorkItems[i].getComputedProbabilityOfCompletionPercentage() //$NON-NLS-1$
//					+ ", slack: " + scheduledWorkItems[i].getComputedAverageSlack()); //$NON-NLS-1$
//			totalSlack += node.getAvgSlack();
		}
	},
	
	createGraph: function(workItems) { 
		var graph = new Graph();
		for (var i = 0; i < workItems.length; i++) {
			var wid = workItems[i];
			var graphNode = this.createGraphNode(wid);
			graph.add(graphNode);
		}			
		return graph;
	},
	
	createGraphNode: function(wi) {
		var estimate = wi.nominalEstimate;
		var lower    = wi.lowerEstimate;
		var upper    = wi.upperEstimate;
		var blocks   = wi.blocks;
		var owner    = wi.ownerUserId;
		
		var deadline = this.deadline;
		var taskDeadline = (typeof(wi["deadline"]) != "undefined" && !isNaN(wi.deadline)) ? wi.deadline : this.deadline; //$NON-NLS-1$ //$NON-NLS-2$
		
		var graphNode = this.createGraphNodeFull(wi.id, lower,estimate,upper,blocks,owner,deadline,taskDeadline);
		return graphNode;
	},

	createGraphNodeFull: function(wid, lower, middle, upper, blocks, owner, deadline, taskDeadline) {		
		var estimate = new TriangularEstimate(lower, middle, upper, ProbabilityDistributionType.TRIANGULAR);
		var graphNode = new GraphNode(wid, estimate);
		graphNode.setTargetCost(deadline);
		graphNode.setEffectiveTargetCost(taskDeadline);
		graphNode.setSuccessors(blocks);
		graphNode.setOwner(owner);
		return graphNode;
	},


	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});
	
})();
