/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.internal.simulation.ACostDistributionRpt"); //$NON-NLS-1$

(function() {

var NEW_LINE = "\n"; //$NON-NLS-1$
var BLANK  = " "; //$NON-NLS-1$

var MIDPOINT_SIZE = 8;

var format= function format(value, fractionalDigits) {
	var num = new Number(value);
	return num.toFixed(fractionalDigits);
};

dojo.declare("com.ibm.team.tempo.shared.client.internal.simulation.ACostDistributionRpt", null, { //$NON-NLS-1$

	constructor: function(dist) {
		this.rptBuf = ""; //$NON-NLS-1$
		this.fillBuf = ""; //$NON-NLS-1$
	    
		this.scaleFactor = Number.NaN;
		this.dataLabelSize = Number.NaN;
		
		this.dist = dist;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getScaleFactor: function (maxCount) {
		var scaleFactor = 0;
		var scaledCount;
		var maxPoints = 50.0;
		
		do {
			scaleFactor++;
			scaledCount = Number(maxCount / scaleFactor).toFixed();
		} while (scaledCount > maxPoints);
		
		return scaleFactor;
	},
	
	addHeader: function (title, dataLabel, maxCount) {
		var scaleFactorMsg = ""; //$NON-NLS-1$
	
		this.dataLabelSize = dataLabel.length +1;
		this.scaleFactor = this.getScaleFactor(maxCount);
		if (this.scaleFactor > 1) {
			scaleFactorMsg = this.getScaleFactorMsg(this.scaleFactor);
		}
		
		this.rptBuf = ""; //$NON-NLS-1$
		this.rptBuf += NEW_LINE + NEW_LINE + title;
		
		this.rptBuf += NEW_LINE + "Midpoint  " + dataLabel + scaleFactorMsg; //$NON-NLS-1$
	},
	
	addDetail: function (midpoint, data, fractionalDigits) {
		var unit = ""; //$NON-NLS-1$
		
		unit = format(data, fractionalDigits);
		
		this.rptBuf += NEW_LINE;	
		this.rptBuf += this.getFill(MIDPOINT_SIZE - midpoint.length) + midpoint;
		
		this.rptBuf += BLANK;
		this.rptBuf += this.getFill(this.dataLabelSize - unit.length) + unit;
		this.rptBuf += BLANK;
			
		this.rptBuf += this.repeat("*", Number(data / this.scaleFactor).toFixed()); //$NON-NLS-1$
	},
	
	addUnivariateStats: function () {
		this.rptBuf += NEW_LINE + NEW_LINE + "Univariate Statistics"; //$NON-NLS-1$
		
		this.rptBuf += NEW_LINE + "  Number of data points = " + this.dist.getN(); //$NON-NLS-1$
		this.rptBuf += NEW_LINE + "  Minimum  = " + format(this.dist.getMinCost(), 2); //$NON-NLS-1$
		this.rptBuf += NEW_LINE + "  Average  = " + format(this.dist.getAvgCost(), 2); //$NON-NLS-1$
		this.rptBuf += NEW_LINE + "  Maximum  = " + format(this.dist.getMaxCost(), 2); //$NON-NLS-1$
		this.rptBuf += NEW_LINE + "  Variance = " + format(this.dist.getVarCost(), 2); //$NON-NLS-1$
		this.rptBuf += NEW_LINE + "  Standard deviation = " + format(this.dist.getStdCost(), 2); //$NON-NLS-1$
	},
	
	getScaleFactorMsg: function (scaleFactor) {
		return ", where each '*' represents " + scaleFactor + " data points."; //$NON-NLS-1$ //$NON-NLS-2$
	},
	
	getFill: function (size) {
		return this.repeat(BLANK, size);
	},
	
	/**
	 * @param value A string value.
	 * @param size The desired size of the string.
	 * @return A string of repeating string values.
	 */
	repeat: function (value, size) {
		this.fillBuf = ""; //$NON-NLS-1$
		
		for (var i = 0; i < size; i++) {
			this.fillBuf += value;
		}
		
		return this.fillBuf;
	},

	print: function () {
//		System.out.println(this.rptBuf.toString());
	},
	
	getRptText: function () {
		return this.rptBuf;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

com.ibm.team.tempo.shared.client.internal.simulation.ACostDistributionRpt.format= format;

})();
