/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2011. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.tempo.shared.client.ProbabilityAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.ScriptableAttribute"); //$NON-NLS-1$

(function() {

var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet		= com.ibm.team.apt.client.PlanningAttributeValueSet;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;

var NOT_AVAILABLE= undefined;
var ID= new PlanningAttributeIdentifier("com.ibm.team.tempo.probability"); //$NON-NLS-1$

dojo.declare("com.ibm.team.tempo.shared.client.ProbabilityAttribute", com.ibm.team.apt.client.ScriptableAttribute, { //$NON-NLS-1$

	__probabilityCache: null, 

	constructor: function(descriptor) {
		this.__probabilityCache= {};
		this.attributeType= PlanningAttributeType.INTEGER;
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	initialize: function(plan) {
	},

	getDependantAttributes: function() {
		return [];
	},

	getValueSet: function() {
		return PlanningAttributeValueSet.EMPTY;
	},
	
	getValue: function(receiver) {
		if (this.__probabilityCache[receiver.getUuid()] == undefined)
			return NOT_AVAILABLE;
		
		return this.__probabilityCache[receiver.getUuid()];
	},

	setValue: function(receiver, newValue) {
		receiver.getPlanModel().compoundChange(function(deltaBuilder) {
			var oldValue= this.__probabilityCache[receiver.getUuid()];
			this.__probabilityCache[receiver.getUuid()]= newValue;
			deltaBuilder.changed(receiver, ID, oldValue, newValue);
		}, this);
	},

	clearValue: function(receiver) {
		if (this.__probabilityCache[receiver.getUuid()] != undefined) {
			receiver.getPlanModel().compoundChange(function(deltaBuilder) {
				var oldValue= this.__probabilityCache[receiver.getUuid()];
				delete this.__probabilityCache[receiver.getUuid()];
				deltaBuilder.changed(receiver, ID, oldValue, undefined);
			}, this);
		}
	},

	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__sentinel: null // terminates this class definition
});

com.ibm.team.tempo.shared.client.ProbabilityAttribute.ID= ID; //$NON-NLS-1$

com.ibm.team.tempo.shared.client.ProbabilityAttribute.NOT_AVAILABLE= NOT_AVAILABLE;

})();
