/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.util.JSMath;
import com.ibm.team.tempo.shared.client.Estimate;
import com.ibm.team.tempo.shared.client.ProbabilityDistribution;
import com.ibm.team.tempo.shared.client.ProbabilityDistributionType;
import com.ibm.team.tempo.shared.client.TriangularDistribution;

public class TriangularEstimate
extends Estimate {
    private TriangularDistribution pd = null;
    private double lowerBound;
    private double middle;
    private double upperBound;

    public TriangularEstimate(double lowerbound, double middle, double upperbound, ProbabilityDistributionType type) {
        this.lowerBound = lowerbound;
        this.middle = middle;
        this.upperBound = upperbound;
        this.setRandomVariate(true);
        if (type == null || type == TriangularDistribution.NAME) {
            this.pd = new TriangularDistribution(this.lowerBound, middle, this.upperBound);
        }
    }

    @Override
    public void computeCost() {
        this.setCost(this.pd.randomCost(JSMath.random()));
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getMiddle() {
        return this.middle;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public TriangularDistribution scale(double r) {
        return this.pd.scale(r);
    }

    public TriangularDistribution getPd() {
        return this.pd;
    }

    @Override
    public String toString() {
        String buf = "lowerBound=";
        buf = String.valueOf(buf) + this.lowerBound;
        buf = String.valueOf(buf) + " middle=";
        buf = String.valueOf(buf) + this.middle;
        buf = String.valueOf(buf) + " upperBound=";
        buf = String.valueOf(buf) + this.upperBound;
        buf = String.valueOf(buf) + " type=";
        buf = String.valueOf(buf) + this.pd.getName().substring(0, 3);
        buf = String.valueOf(buf) + " isRandomVariate = " + this.isRandomVariate();
        return buf;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProbabilityDistribution) {
            return this.getLowerBound() == this.pd.getLowerbound() && this.getMiddle() == this.pd.getMiddle() && this.getUpperBound() == this.pd.getUpperbound();
        }
        return false;
    }
}

