/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.util.JSMath;
import com.ibm.team.tempo.shared.client.ProbabilityDistribution;
import com.ibm.team.tempo.shared.client.ProbabilityDistributionType;

public class TriangularDistribution
extends ProbabilityDistribution {
    public static ProbabilityDistributionType NAME = ProbabilityDistributionType.TRIANGULAR;
    private double lowerbound;
    private double middle;
    private double upperbound;

    public TriangularDistribution(double lb, double m, double ub) {
        this.lowerbound = lb;
        this.middle = m;
        this.upperbound = ub;
    }

    @Override
    public double randomCost(double rand) {
        double cost = 0.0;
        if (this.upperbound == this.lowerbound) {
            return this.upperbound;
        }
        double delta = this.middle - this.lowerbound;
        double a1 = delta / (this.upperbound - this.lowerbound);
        cost = rand <= a1 ? JSMath.sqrt((double)(rand / a1)) * delta + this.lowerbound : this.upperbound - JSMath.sqrt((double)((1.0 - rand) / (1.0 - a1))) * (this.upperbound - this.middle);
        return cost;
    }

    @Override
    public TriangularDistribution scale(double r) {
        double ub;
        double lb;
        double m;
        if (r >= 0.0) {
            m = this.middle * r;
            lb = this.lowerbound * r;
            ub = this.upperbound * r;
        } else {
            m = this.middle * r;
            lb = this.upperbound * r;
            ub = this.lowerbound * r;
        }
        TriangularDistribution result = new TriangularDistribution(lb, m, ub);
        return result;
    }

    public TriangularDistribution convolute(TriangularDistribution[] tdvector) {
        double[] gammaOut = new double[]{1.0, 0.0, 0.0, 0.0};
        int i = 0;
        while (i < tdvector.length) {
            double[] gamma = tdvector[i].gammas();
            int j = 1;
            while (j < gamma.length) {
                int n = j;
                gammaOut[n] = gammaOut[n] + gamma[j];
                ++j;
            }
            ++i;
        }
        return this.fromGammas(gammaOut);
    }

    public TriangularDistribution fromGammas(double[] gamma) {
        double x = 0.0;
        double y = 0.0;
        double discriminant = 8.0 * gamma[2] * gamma[2] * gamma[2] - 25.0 * gamma[3] * gamma[3];
        if (discriminant < 0.0) {
            y = 3.0 * JSMath.sqrt((double)(gamma[2] / 2.0)) * JSMath.signum((double)gamma[3]);
            x = JSMath.abs((double)y);
        } else {
            double ymax = 3.0 * JSMath.sqrt((double)(gamma[2] / 2.0));
            double ymin = -ymax;
            double fy = this.F2(ymax, gamma);
            fy = this.F2(ymin, gamma);
            int i = 0;
            while (i < 100) {
                y = (ymax + ymin) / 2.0;
                fy = this.F2(y, gamma);
                if (fy <= 0.0) {
                    ymax = y;
                }
                if (fy >= 0.0) {
                    ymin = y;
                }
                if (ymax == ymin) break;
                ++i;
            }
            x = JSMath.sqrt((double)(6.0 * gamma[2] - y * y / 3.0));
        }
        double m = gamma[1] - 2.0 * y / 3.0;
        double u = m + x + y;
        double l = m - x + y;
        return new TriangularDistribution(l, m, u);
    }

    public double F2(double y, double[] gamma) {
        return 4.0 * y * y * y - 54.0 * gamma[2] * y + 135.0 * gamma[3];
    }

    public double[] gammas() {
        double[] gamma = new double[]{1.0, (this.lowerbound + this.middle + this.upperbound) / 3.0, (this.upperbound * this.upperbound + this.middle * this.middle + this.lowerbound * this.lowerbound - this.upperbound * this.middle - this.middle * this.lowerbound - this.lowerbound * this.upperbound) / 18.0, (this.upperbound - 2.0 * this.middle + this.lowerbound) * (this.upperbound + this.middle - 2.0 * this.lowerbound) * (2.0 * this.upperbound - this.middle - this.lowerbound) / 270.0};
        return gamma;
    }

    public TriangularDistribution fromMoments(double[] p) {
        double p1 = p[1] / p[0];
        double p2 = p[2] / p[0];
        double p3 = p[3] / p[0];
        double gamma1 = p1;
        double gamma2 = p2 - p1 * p1;
        double gamma3 = p3 - 3.0 * p1 * p2 + 2.0 * p1 * p1 * p1;
        double x = 0.0;
        double y = 0.0;
        double discriminant = 8.0 * gamma2 * gamma2 * gamma2 - 25.0 * gamma3 * gamma3;
        if (discriminant < 0.0) {
            y = 3.0 * JSMath.sqrt((double)(gamma2 / 2.0)) * JSMath.signum((double)gamma3);
            x = JSMath.abs((double)y);
        } else {
            double ymax = 3.0 * JSMath.sqrt((double)(gamma2 / 2.0));
            double ymin = -ymax;
            double fy = this.F3(ymax, gamma2, gamma3);
            fy = this.F3(ymin, gamma2, gamma3);
            int i = 0;
            while (i < 100) {
                y = (ymax + ymin) / 2.0;
                fy = this.F3(y, gamma2, gamma3);
                if (fy <= 0.0) {
                    ymax = y;
                }
                if (fy >= 0.0) {
                    ymin = y;
                }
                if (ymax == ymin) break;
                ++i;
            }
            x = JSMath.sqrt((double)(6.0 * gamma2 - y * y / 3.0));
        }
        double m = gamma1 - 2.0 * y / 3.0;
        double u = m + x + y;
        double l = m - x + y;
        return new TriangularDistribution(l, m, u);
    }

    public double F3(double y, double gamma2, double gamma3) {
        return 4.0 * y * y * y - 54.0 * gamma2 * y + 135.0 * gamma3;
    }
}

