/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.OwnerNodeListUtil;

public class Traverser
extends DojoObject {
    public void batchOptimization(GraphNode graphNode, GraphNode[] ownerNodeLst) {
        GraphNode nextFreeNode;
        if (graphNode.getSlack() > 0.0 && (nextFreeNode = OwnerNodeListUtil.getNextFreeNode(graphNode, ownerNodeLst)) != null) {
            GraphNode prevOwnerNode = OwnerNodeListUtil.getPreviousOwnerNode(graphNode, ownerNodeLst);
            Object[] successors = prevOwnerNode.getSuccessors();
            int successorPos = JSArrays.indexOf((Object[])successors, (Object)graphNode.getId());
            if (successorPos > -1) {
                JSArrays.splice((Object[])successors, (int)successorPos, (int)1);
            }
            prevOwnerNode.addSuccessor(nextFreeNode.getId());
            double nextFreeNodeCumulativeCost = prevOwnerNode.getCumulativeCost() + nextFreeNode.getTotalCost();
            nextFreeNode.setCumulativeCost(nextFreeNodeCumulativeCost);
            GraphNode[] predecessors = nextFreeNode.getPredecessors();
            int predecessorPos = JSArrays.indexOf((Object[])predecessors, (Object)((Object)graphNode));
            if (predecessorPos > -1) {
                JSArrays.splice((Object[])predecessors, (int)predecessorPos, (int)1);
            }
            this.computeSlack(nextFreeNode, prevOwnerNode);
            graphNode.setCumulativeCost(nextFreeNodeCumulativeCost + graphNode.getTotalCost());
            successors = graphNode.getSuccessors();
            successorPos = JSArrays.indexOf((Object[])successors, (Object)nextFreeNode.getId());
            if (successorPos > -1) {
                JSArrays.splice((Object[])successors, (int)successorPos, (int)1);
            }
            graphNode.addSuccessor(OwnerNodeListUtil.getNextOwnerNode(graphNode, ownerNodeLst).getId());
            this.computeSlack(graphNode, nextFreeNode);
        }
    }

    public void computeSlack(GraphNode graphNode, GraphNode prevOwnerNode) {
        if (prevOwnerNode != null) {
            if (graphNode.getOwner() == prevOwnerNode.getOwner()) {
                if (graphNode.getConstraintPredecessor() == null) {
                    graphNode.setSlack(0.0);
                } else {
                    double slack = 0.0;
                    slack = graphNode.getConstraintPredecessor().getCumulativeCost() - prevOwnerNode.getCumulativeCost();
                    if (slack < 0.0) {
                        slack = 0.0;
                    }
                    graphNode.setSlack(slack);
                }
            }
        } else {
            double slack = 0.0;
            GraphNode constraintPredecessor = graphNode.getConstraintPredecessor();
            if (constraintPredecessor != null) {
                slack = graphNode.getConstraintPredecessor().getCumulativeCost();
            }
            if (slack < 0.0) {
                slack = 0.0;
            }
            graphNode.setSlack(slack);
        }
    }
}

