/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMap;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.ImpactFunc;
import com.ibm.team.tempo.shared.client.OwnerScheduledGraph;
import com.ibm.team.tempo.shared.client.TriangularEstimate;

public class ScheduleByOwner
extends DojoObject {
    private OwnerScheduledGraph ownerScheduledGraph;
    private GraphNode[] scheduleResult;

    public ScheduleByOwner(OwnerScheduledGraph ownerScheduledGraph) {
        this.ownerScheduledGraph = ownerScheduledGraph;
    }

    public void load() {
        this.scheduleResult = new GraphNode[0];
        JSMap<GraphNode[]> ownerNodeTbl = this.ownerScheduledGraph.getOwnerGraphNodeTbl();
        String[] stringArray = ownerNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ownerId = stringArray[n2];
            GraphNode[] ownerNodes = (GraphNode[])ownerNodeTbl.get(ownerId);
            int j = 0;
            while (j < ownerNodes.length) {
                GraphNode graphNode = ownerNodes[j];
                JSArrays.push((Object[])this.scheduleResult, (Object)((Object)graphNode));
                this.populateImpact(graphNode);
                ++j;
            }
            ++n2;
        }
    }

    public GraphNode[] getScheduleResult() {
        return this.scheduleResult;
    }

    public OwnerScheduledGraph getGraph() {
        return this.ownerScheduledGraph;
    }

    public void populateImpact(GraphNode graphNode) {
        TriangularEstimate estimate = graphNode.getEstimate();
        double impactDbl = ImpactFunc.getValue(estimate.getPd());
        graphNode.setImpact(impactDbl);
    }
}

