/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.base.dojo;
import com.ibm.jdojo.lang.Console;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.reflection.Types;
import com.ibm.jdojo.util.IMappable;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.TypedJSMap;
import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanItem;
import com.ibm.team.apt.api.client.IPlanModel;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.client.IWorktimeProvider;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.api.common.IUIItem;
import com.ibm.team.apt.api.common.UIItemHandle;
import com.ibm.team.apt.api.common.process.IIteration;
import com.ibm.team.apt.api.common.repository.IContributor;
import com.ibm.team.apt.api.common.repository.IReference;
import com.ibm.team.apt.api.common.repository.IReferences;
import com.ibm.team.apt.api.common.workitem.Duration;
import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.api.common.workitem.IWorkItemType;
import com.ibm.team.apt.shared.client.internal.SequenceValue;
import com.ibm.team.apt.shared.client.internal.duration.Instant;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeScheduler;
import com.ibm.team.tempo.shared.client.Graph;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.GraphOptimization;
import com.ibm.team.tempo.shared.client.MonteCarloGraphNode;
import com.ibm.team.tempo.shared.client.OptimizationResults;
import com.ibm.team.tempo.shared.client.OwnerScheduledGraph;
import com.ibm.team.tempo.shared.client.ProbabilityDistributionType;
import com.ibm.team.tempo.shared.client.ScheduleByOwner;
import com.ibm.team.tempo.shared.client.TriangularEstimate;

public class PlanModelAdapter
extends DojoObject {
    private static final int NUM_SIMULATION_ITERATIONS = 1000;
    private JSMap<Long> deadlineCache;
    private JSMap<IPlanElement[]> ownerElementMap;
    private IPlanElement[] topLevelItems;
    private IPlanModel planModel;
    private WorktimeScheduler scheduler;
    private GraphOptimization graphOptimization;
    private IPlanElement[] planElements;
    private static final String NO_OWNER_ID = "NoOwner";

    public PlanModelAdapter(IPlanModel planModel) {
        this.planModel = planModel;
        this.topLevelItems = new IPlanElement[0];
        this.ownerElementMap = new JSMap();
        this.deadlineCache = new JSMap();
        this.graphOptimization = null;
    }

    public void initialize() {
        this.processPlanElements();
        this.createGraph();
    }

    public TypedJSMap<IPlanElement, Double> computeCompletionProbabilities() {
        TypedJSMap result = new TypedJSMap();
        OptimizationResults optimizationResults = this.graphOptimization.simulate(1000);
        JSMap<MonteCarloGraphNode> graphNodeTable = optimizationResults.getMonteCarloNodeTbl();
        String[] stringArray = graphNodeTable.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String planItemId = stringArray[n2];
            IPlanElement planItem = this.planModel.getPlanElement(planItemId);
            MonteCarloGraphNode graphNode = (MonteCarloGraphNode)((Object)graphNodeTable.get(planItemId));
            Double probOfCompletion = graphNode.getProbabilityToComplete();
            result.put((IMappable)planItem, (Object)probOfCompletion);
            ++n2;
        }
        this.computeTopLevelItemProbabilities((TypedJSMap<IPlanElement, Double>)result, graphNodeTable);
        return result;
    }

    protected long getRemainingWorkTime(IContributor owner, IIteration iteration) {
        IInstant endDate;
        if (owner == null || iteration == null) {
            return 0L;
        }
        IInstant startDate = iteration.getStartDate();
        IInstant now = (IInstant)this.planModel.getAttributeValue(IPlanModel.REFERENCE_TIME);
        if (now == null) {
            now = Instant.currentTime();
        }
        if (startDate == null || startDate.before(now)) {
            startDate = now;
        }
        if ((endDate = iteration.getEndDate()) == null || endDate.before(startDate)) {
            return 0L;
        }
        Timespan iterationDuration = new Timespan(startDate, endDate);
        IPlanningAttribute attribute = this.planModel.findAttribute(IPlanModel.AGILE_WORKTIME_SCHEDULER);
        IWorktimeProvider worktimeProvider = (IWorktimeProvider)attribute.getAdapter(IWorktimeProvider.class);
        return worktimeProvider.getWorktime(UIItemHandle.itemHandleFor((IUIItem)owner), (ITimespan)iterationDuration, null);
    }

    protected void processPlanElements() {
        this.planElements = this.planModel.getAllPlanElements();
        int i = 0;
        while (i < this.planElements.length) {
            IPlanElement planElement = this.planElements[i];
            if (planElement.getAdapter(IPlanItem.class) != null && !this.isResolved(planElement)) {
                if (this.isTopLevelItem(planElement)) {
                    JSArrays.push((Object[])this.topLevelItems, (Object)planElement);
                } else {
                    IContributor owner = this.getOwner(planElement);
                    String ownerId = owner == null ? NO_OWNER_ID : owner.getItemId();
                    Object[] ownerElts = (IPlanElement[])this.ownerElementMap.get(ownerId);
                    if (ownerElts == null) {
                        ownerElts = new IPlanElement[]{};
                        this.ownerElementMap.put(ownerId, (Object)ownerElts);
                    }
                    JSArrays.push((Object[])ownerElts, (Object)planElement);
                }
            }
            ++i;
        }
        this.sortOwnerElements();
    }

    protected void sortOwnerElements() {
        String[] stringArray = this.ownerElementMap.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ownerId = stringArray[n2];
            Object[] ownerElts = (IPlanElement[])this.ownerElementMap.get(ownerId);
            JSArrays.sort((Object[])ownerElts, (JSArrays.IComparator)new JSArrays.IComparator<IPlanElement>(){

                public int compare(IPlanElement left, IPlanElement right) {
                    SequenceValue rightValue;
                    SequenceValue leftValue = PlanModelAdapter.this.getSequenceValue(left);
                    if (leftValue == (rightValue = PlanModelAdapter.this.getSequenceValue(right))) {
                        return 0;
                    }
                    if (leftValue == null) {
                        return rightValue.compareTo(leftValue);
                    }
                    return leftValue.compareTo(rightValue);
                }
            });
            ++n2;
        }
    }

    protected void createGraph() {
        Graph graph = new Graph();
        String[] stringArray = this.ownerElementMap.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ownerId = stringArray[n2];
            IPlanElement[] ownerElts = (IPlanElement[])this.ownerElementMap.get(ownerId);
            this.createGraphNodes(graph, ownerElts);
            ++n2;
        }
        OwnerScheduledGraph ownerScheduledGraph = new OwnerScheduledGraph(graph.getOrigNodeLst());
        ScheduleByOwner scheduleGenerator = new ScheduleByOwner(ownerScheduledGraph);
        scheduleGenerator.load();
        this.graphOptimization = new GraphOptimization(scheduleGenerator);
    }

    private void dumpGraph(OwnerScheduledGraph graph) {
        JSMap<GraphNode[]> ownerGraphNodeTbl = graph.getOwnerGraphNodeTbl();
        String buf = "";
        String[] stringArray = ownerGraphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ownerId = stringArray[n2];
            GraphNode[] ownerNodes = (GraphNode[])ownerGraphNodeTbl.get(ownerId);
            buf = String.valueOf(buf) + "Nodes for owner: " + ownerId + "\n";
            int i = 0;
            while (i < ownerNodes.length) {
                GraphNode node = ownerNodes[i];
                TriangularEstimate te = node.getEstimate();
                buf = String.valueOf(buf) + node.getId() + " [" + te.getLowerBound() + ", " + te.getMiddle() + ", " + te.getUpperBound() + "]\n";
                ++i;
            }
            buf = String.valueOf(buf) + "\n";
            ++n2;
        }
        buf = String.valueOf(buf);
        Console.log((Object)buf);
    }

    protected void createGraphNodes(Graph graph, IPlanElement[] elts) {
        IPlanElement[] iPlanElementArray = elts;
        int n = elts.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanElement e = iPlanElementArray[n2];
            GraphNode graphNode = this.createGraphNode(e);
            graph.add((Object)graphNode);
            ++n2;
        }
    }

    protected GraphNode createGraphNode(IPlanElement e) {
        IDuration minimal = this.getMinimalEstimate(e);
        IDuration nominal = this.getEstimate(e);
        IDuration maximal = this.getMaximalEstimate(e);
        if (!(nominal.isSpecified() && minimal.isSpecified() && maximal.isSpecified())) {
            if (!nominal.isSpecified()) {
                nominal = minimal.isSpecified() || maximal.isSpecified() ? (minimal.isSpecified() && maximal.isSpecified() ? new Duration((minimal.getMilliseconds() + maximal.getMilliseconds()) / 2L) : (minimal.isSpecified() ? new Duration(minimal.getMilliseconds() * 2L) : new Duration(maximal.getMilliseconds() / 2L))) : new Duration(0L);
            }
            if (!minimal.isSpecified()) {
                minimal = new Duration(nominal.getMilliseconds() / 2L);
            }
            if (!maximal.isSpecified()) {
                maximal = new Duration(nominal.getMilliseconds() * 2L);
            }
        }
        if (minimal.getMilliseconds() > nominal.getMilliseconds()) {
            minimal = nominal;
        }
        if (maximal.getMilliseconds() < nominal.getMilliseconds()) {
            maximal = nominal;
        }
        TriangularEstimate estimate = new TriangularEstimate(minimal.getMilliseconds(), nominal.getMilliseconds(), maximal.getMilliseconds(), ProbabilityDistributionType.TRIANGULAR);
        GraphNode result = new GraphNode(e.getIdentifier(), (Object)estimate);
        IContributor owner = this.getOwner(e);
        String ownerId = owner == null ? NO_OWNER_ID : owner.getItemId();
        result.setOwner(ownerId);
        IIteration targetIteration = this.getTarget(e);
        long deadline = this.getDeadline(owner, targetIteration);
        result.setTargetCost(deadline);
        result.setEffectiveTargetCost(deadline);
        IPlanElement parent = this.getParent(e);
        if (parent != null && parent instanceof IPlanItem) {
            IPlanItem p = (IPlanItem)parent;
            result.setParent(p);
        }
        return result;
    }

    protected long getDeadline(IContributor owner, IIteration targetIteration) {
        String cacheKey = (owner == null ? NO_OWNER_ID : owner.getItemId()).toString();
        Long result = (Long)this.deadlineCache.get(cacheKey = String.valueOf(cacheKey) + "," + (targetIteration != null ? targetIteration.getItemId() : "NoIteration").toString());
        if (result == null) {
            result = this.getRemainingWorkTime(owner, targetIteration);
            this.deadlineCache.put(cacheKey, (Object)result);
        }
        return result;
    }

    protected void computeTopLevelItemProbabilities(TypedJSMap<IPlanElement, Double> result, JSMap<MonteCarloGraphNode> graphNodeTable) {
        TypedJSMap<IPlanElement, MonteCarloGraphNode[]> parentToLastChildMap = this.createParentToLastChildMap(graphNodeTable);
        String[] stringArray = parentToLastChildMap.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String planItemId = stringArray[n2];
            IPlanElement topLevelItem = this.planModel.getPlanElement(planItemId);
            MonteCarloGraphNode[] children = (MonteCarloGraphNode[])parentToLastChildMap.get(planItemId);
            Double probOfAllChildrenCompleting = this.computeProbabilityOfCompletionOfAll(children);
            result.put((IMappable)topLevelItem, (Object)probOfAllChildrenCompleting);
            ++n2;
        }
    }

    protected TypedJSMap<IPlanElement, MonteCarloGraphNode[]> createParentToLastChildMap(JSMap<MonteCarloGraphNode> graphNodeTable) {
        TypedJSMap result = new TypedJSMap();
        int i = 0;
        while (i < this.topLevelItems.length) {
            IPlanElement topLevelItem = this.topLevelItems[i];
            MonteCarloGraphNode[] children = this.findLastDescendants(topLevelItem, graphNodeTable);
            result.put((IMappable)topLevelItem, (Object)children);
            ++i;
        }
        return result;
    }

    protected MonteCarloGraphNode[] findLastDescendants(IPlanElement topLevelItem, JSMap<MonteCarloGraphNode> graphNodeTable) {
        JSMap ownerToLastDescendantMap = new JSMap();
        JSMap ownerToLastDescendantIndexMap = new JSMap();
        IPlanElement[] descendants = new IPlanElement[]{};
        this.findNonTopLevelDescendants(topLevelItem, descendants);
        int i = 0;
        while (i < descendants.length) {
            IPlanElement descendant = descendants[i];
            IContributor owner = this.getOwner(descendant);
            String ownerId = owner == null ? NO_OWNER_ID : owner.getItemId();
            Object[] ownersChildren = (IPlanElement[])this.ownerElementMap.get(ownerId);
            Integer currIndex = (Integer)ownerToLastDescendantIndexMap.get(ownerId);
            Integer newIndex = dojo.indexOf((Object[])ownersChildren, (Object)descendant);
            assert (newIndex != -1);
            if (currIndex == null || newIndex > currIndex) {
                ownerToLastDescendantIndexMap.put(ownerId, (Object)newIndex);
                Object newChild = ownersChildren[newIndex];
                MonteCarloGraphNode newChildNode = (MonteCarloGraphNode)((Object)graphNodeTable.get(newChild.getIdentifier()));
                ownerToLastDescendantMap.put(ownerId, (Object)newChildNode);
            }
            ++i;
        }
        MonteCarloGraphNode[] result = new MonteCarloGraphNode[]{};
        String[] stringArray = ownerToLastDescendantMap.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ownerId = stringArray[n2];
            MonteCarloGraphNode lastChildNode = (MonteCarloGraphNode)((Object)ownerToLastDescendantMap.get(ownerId));
            JSArrays.push((Object[])result, (Object)((Object)lastChildNode));
            ++n2;
        }
        return result;
    }

    protected void findNonTopLevelDescendants(IPlanElement item, IPlanElement[] descendants) {
        if (!this.isPlanItem(item) || this.isResolved(item)) {
            return;
        }
        if (!this.isTopLevelItem(item)) {
            JSArrays.push((Object[])descendants, (Object)item);
            return;
        }
        IPlanElement[] children = this.getChildren(item);
        if (children == null) {
            return;
        }
        int j = 0;
        while (j < children.length) {
            IPlanElement child = children[j];
            this.findNonTopLevelDescendants(child, descendants);
            ++j;
        }
    }

    protected Double computeProbabilityOfCompletionOfAll(MonteCarloGraphNode[] nodes) {
        double result = 1.0;
        int i = 0;
        while (i < nodes.length) {
            MonteCarloGraphNode child = nodes[i];
            double childProb = child.getProbabilityToComplete();
            result *= childProb;
            ++i;
        }
        return result;
    }

    protected boolean isPlanItem(IPlanElement item) {
        return dojo.indexOf((Object[])this.planElements, (Object)item) != -1;
    }

    private SequenceValue getSequenceValue(IPlanElement planElement) {
        return (SequenceValue)Types.cast((Object)planElement.getAttributeValue(IPlanItem.SEQUENCE_VALUE), SequenceValue.class);
    }

    private IContributor getOwner(IPlanElement planElement) {
        return (IContributor)Types.cast((Object)planElement.getAttributeValue(IPlanItem.OWNER), IContributor.class);
    }

    private boolean isTopLevelItem(IPlanElement planElement) {
        IWorkItemType itemType = (IWorkItemType)planElement.getAttributeValue(IPlanItem.ITEM_TYPE);
        if (itemType == null) {
            return false;
        }
        return itemType.isTopLevel();
    }

    private boolean isResolved(IPlanElement planElement) {
        return (Boolean)planElement.getAttributeValue(IPlanItem.RESOLVED);
    }

    private IIteration getTarget(IPlanElement planElement) {
        if (planElement == null) {
            return null;
        }
        return (IIteration)planElement.getAttributeValue(IPlanItem.TARGET);
    }

    private IDuration getMinimalEstimate(IPlanElement planItem) {
        IDuration result = (IDuration)planItem.getAttributeValue(IPlanItem.MINIMAL_ESTIMATE);
        return result != null ? result : Duration.UNSPECIFIED;
    }

    private IDuration getEstimate(IPlanElement planItem) {
        IDuration result = (IDuration)planItem.getAttributeValue(IPlanItem.ESTIMATE);
        return result != null ? result : Duration.UNSPECIFIED;
    }

    private IDuration getMaximalEstimate(IPlanElement planItem) {
        IDuration result = (IDuration)planItem.getAttributeValue(IPlanItem.MAXIMAL_ESTIMATE);
        return result != null ? result : Duration.UNSPECIFIED;
    }

    private IPlanElement getParent(IPlanElement planElement) {
        IReferences parentrfs = (IReferences)planElement.getAttributeValue(IPlanItem.PARENT);
        if (parentrfs == null) {
            return null;
        }
        IReference[] references = parentrfs.getReferences();
        if (references == null || references.length == 0) {
            return null;
        }
        assert (references.length <= 1);
        if (references[0] == null) {
            return null;
        }
        return this.planModel.getPlanElement(references[0].getItemHandle().getItemId());
    }

    private IPlanElement[] getChildren(IPlanElement planElement) {
        IPlanElement[] children = new IPlanElement[]{};
        IReferences childrenrfs = (IReferences)planElement.getAttributeValue(IPlanItem.CHILDREN);
        if (childrenrfs == null) {
            return null;
        }
        IReference[] references = childrenrfs.getReferences();
        if (references == null || references.length == 0) {
            return null;
        }
        int i = 0;
        while (i < references.length) {
            children[i] = this.planModel.getPlanElement(references[i].getItemHandle().getItemId());
            ++i;
        }
        return children;
    }
}

