/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.util.JSMap;
import com.ibm.team.tempo.shared.client.Graph;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.ITraverser;
import com.ibm.team.tempo.shared.client.OwnerNodeListUtil;
import com.ibm.team.tempo.shared.client.Traverser;

public class NbTraverser
extends Traverser
implements ITraverser {
    private JSMap<GraphNode[]> ownerNodeTbl = null;
    private JSMap<GraphNode> graphNodeTbl = null;
    private GraphNode criticalPathTailNode = null;
    private GraphNode headNode;
    private int lookupCount = 0;
    private double cost = 0.0;

    @Override
    public void run(Graph graph, JSMap<GraphNode[]> ownerNodeTbl) {
        this.ownerNodeTbl = ownerNodeTbl;
        this.graphNodeTbl = graph.getGraphNodeTbl();
        this.cost = 0.0;
        this.lookupCount = 0;
        this.initHeadNodeCostFields(graph);
        graph.initUnproccessedPredecessorCount();
        GraphNode[] headNodes = graph.getHeadNodes();
        int i = 0;
        while (i < headNodes.length) {
            GraphNode headNode = headNodes[i];
            this.processNode(headNode);
            ++i;
        }
    }

    @Override
    public GraphNode getCriticalPathTailNode() {
        return this.criticalPathTailNode;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public int getLookupCount() {
        return this.lookupCount;
    }

    @Override
    public JSMap<GraphNode[]> getOwnerNodeTbl() {
        return this.ownerNodeTbl;
    }

    public void setCriticalPathTailNode(GraphNode criticalPathTailNode) {
        this.criticalPathTailNode = criticalPathTailNode;
    }

    public JSMap<GraphNode> getGraphNodeTbl() {
        return this.graphNodeTbl;
    }

    public void processNode(GraphNode graphNode) {
        GraphNode[] ownerNodeLst = null;
        if (this.ownerNodeTbl != null) {
            ownerNodeLst = (GraphNode[])this.ownerNodeTbl.get(graphNode.getOwner());
            ++this.lookupCount;
            this.computeSlack(graphNode, OwnerNodeListUtil.getPreviousOwnerNode(graphNode, ownerNodeLst));
        }
        this.batchOptimization(graphNode, ownerNodeLst);
        String[] successors = graphNode.getSuccessors();
        int i = 0;
        while (i < successors.length) {
            String successorId = successors[i];
            GraphNode successor = (GraphNode)((Object)this.graphNodeTbl.get(successorId));
            graphNode.setProcessedNode(true);
            ++this.lookupCount;
            if (successor.getUnprocessedPredecessors() > 0) {
                this.computeCumulativeCost(successor);
                this.processNode(successor);
            }
            ++i;
        }
        if (graphNode.getSuccessors().length == 0) {
            this.updateTotal(graphNode);
        }
    }

    public double computeCumulativeCost(GraphNode graphNode) {
        if (!graphNode.isProcessedNode() && graphNode.getNrOfPredecessors() > 0) {
            GraphNode[] predecessors = graphNode.getPredecessors();
            int i = 0;
            while (i < predecessors.length) {
                ++this.lookupCount;
                GraphNode predecessor = predecessors[i];
                graphNode.decrementUnprocessedPredecessors();
                double predecessorCumulativeCost = this.computeCumulativeCost(predecessor);
                double cumulativeCost = predecessorCumulativeCost + graphNode.getTotalCost();
                if (cumulativeCost > graphNode.getCumulativeCost()) {
                    graphNode.setCumulativeCost(cumulativeCost);
                    graphNode.setConstraintPredecessor(predecessor);
                }
                ++i;
            }
        }
        graphNode.setProcessedNode(true);
        return graphNode.getCumulativeCost();
    }

    public void initHeadNodeCostFields(Graph graph) {
        GraphNode[] headNodes = graph.getHeadNodes();
        int i = 0;
        while (i < headNodes.length) {
            GraphNode headNode = headNodes[i];
            headNode.setCumulativeCost(headNode.getTotalCost());
            ++i;
        }
    }

    public void updateTotal(GraphNode graphNode) {
        if (graphNode.getCumulativeCost() > this.cost) {
            this.setCriticalPathTailNode(graphNode);
            this.cost = graphNode.getCumulativeCost();
        }
    }
}

