/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.apt.api.client.IPlanItem;
import com.ibm.team.tempo.shared.client.CostDistribution;
import com.ibm.team.tempo.shared.client.CostDistributionRpt;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.TriangularEstimate;

public class MonteCarloGraphNode
extends DojoObject {
    private JSMap<Double> modeTbl = new JSMap();
    private double modeCost = -1.0;
    private double totCost = 0.0;
    private double totSlack = 0.0;
    private double targetCost = 0.0;
    private double totSlackPlusTotCost = 0.0;
    private int effectiveAbilityToCompleteCount = 0;
    private int ableToCompleteCount = 0;
    private int onCritPathCount = 0;
    private int onTargetCount = 0;
    private boolean isWithNodeDistributions;
    private CostDistribution costDistribution;
    private String id;
    private TriangularEstimate estimate;
    private int n;
    private Double[] cumulativeCosts;
    private double avgCumulativeCost;
    private double computedProbabilityOfCompletionPercentage;
    private double computedAverageSlack;
    private double averageSlack;
    private double computedAverageTime;
    private IPlanItem parent;
    private String ownerId;

    public MonteCarloGraphNode(GraphNode graphNode, int n, boolean isWithNodeDistributions) {
        this.isWithNodeDistributions = isWithNodeDistributions;
        this.costDistribution = new CostDistribution(n, null);
        this.cumulativeCosts = new Double[0];
        this.avgCumulativeCost = -1.0;
        this.n = n;
        this.parent = graphNode.getParent();
        this.ownerId = graphNode.getOwner();
    }

    public IPlanItem getParent() {
        return this.parent;
    }

    public void setParent(IPlanItem parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public int getOnTargetCount() {
        return this.onTargetCount;
    }

    public int getAbleToCompleteCount() {
        return this.ableToCompleteCount;
    }

    public int getOnCritPathCount() {
        return this.onCritPathCount;
    }

    public double getModeCost() {
        if (this.modeCost < 0.0) {
            this.computeMode();
        }
        return this.modeCost;
    }

    public double getAvgCost() {
        return this.totCost / (double)this.n;
    }

    public double getAvgSlack() {
        return this.totSlack / (double)this.n;
    }

    public double getAvgSlackPlusTotCost() {
        return this.totSlackPlusTotCost / (double)this.n;
    }

    public void updateSlack(double slack) {
        this.totSlack += slack;
    }

    public void updateSlackPlusTotCost(double slackPlusTotCost) {
        this.totSlackPlusTotCost += slackPlusTotCost;
    }

    public double getProbabilityOfOnTime() {
        return ((double)this.getOnTargetCount() - 0.0) / ((double)this.n - 0.0);
    }

    public double getProbabilityToComplete() {
        return ((double)this.getAbleToCompleteCount() - 0.0) / ((double)this.n - 0.0);
    }

    public double getEffectiveProbabilityToComplete() {
        return ((double)this.effectiveAbilityToCompleteCount - 0.0) / ((double)this.n - 0.0);
    }

    public double getTargetCost() {
        return this.targetCost;
    }

    public double sortNumber(double a, double b) {
        return a - b;
    }

    public double getAvgCumulativeCost() {
        if (this.avgCumulativeCost < 0.0) {
            double avg = 0.0;
            int i = 0;
            while (i < this.cumulativeCosts.length) {
                avg += this.cumulativeCosts[i].doubleValue();
                ++i;
            }
            this.avgCumulativeCost = avg / (double)this.cumulativeCosts.length;
        }
        return this.avgCumulativeCost;
    }

    public String showResults() {
        double L = this.estimate.getLowerBound();
        double N = this.estimate.getMiddle();
        double H = this.estimate.getUpperBound();
        String buf = "";
        buf = String.valueOf(buf) + " NodeId=" + this.getId();
        buf = String.valueOf(buf) + " L/N/H=" + L + "/" + N + "/" + H + " target=" + this.targetCost;
        buf = String.valueOf(buf) + " mode=" + this.getModeCost();
        buf = String.valueOf(buf) + " critPathCt=" + this.getOnCritPathCount();
        buf = String.valueOf(buf) + " targetCt=" + this.getOnTargetCount();
        buf = String.valueOf(buf) + " avgSlack=" + this.getAvgSlack();
        buf = String.valueOf(buf) + " avg completion time=" + this.getAvgCumulativeCost();
        buf = String.valueOf(buf) + " probToComplete=" + this.getProbabilityToComplete();
        buf = String.valueOf(buf) + " effProbToComplete=" + this.getEffectiveProbabilityToComplete();
        return buf;
    }

    public void updateAbleToCompleteCount(double overallCost, double overallTargetCost) {
        if (overallCost <= overallTargetCost) {
            ++this.ableToCompleteCount;
        }
    }

    public void updateEffectiveAbilityToCompleteCount(Double cumulativeCost, double effectiveTargetCost) {
        if (cumulativeCost <= effectiveTargetCost) {
            ++this.effectiveAbilityToCompleteCount;
        }
        JSArrays.push((Object[])this.cumulativeCosts, (Object)cumulativeCost);
    }

    public void updateCostFields(double cost) {
        if (this.isWithNodeDistributions) {
            this.costDistribution.update(cost);
        }
        this.updateModeTbl(cost);
        if (cost <= this.targetCost) {
            ++this.onTargetCount;
        }
        this.totCost += cost;
    }

    public void incrementOnCritPathCount() {
        ++this.onCritPathCount;
    }

    public void resetCounters() {
        this.effectiveAbilityToCompleteCount = 0;
        this.ableToCompleteCount = 0;
        this.onCritPathCount = 0;
        this.onTargetCount = 0;
        this.modeTbl = new JSMap();
        this.modeCost = 0.0;
        this.cumulativeCosts = new Double[0];
        this.avgCumulativeCost = -1.0;
    }

    public void updateModeTbl(double cost) {
        String costStr = String.valueOf(JSMath.round((double)cost));
        if (this.modeTbl.get(costStr) != null) {
            int count = JSMath.round((double)((Double)this.modeTbl.get(costStr)));
            this.modeTbl.put(costStr, (Object)count++);
        } else {
            this.modeTbl.put(costStr, (Object)1.0);
        }
    }

    public void computeMode() {
        int prevCount = 0;
        String[] stringArray = this.modeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            double count = (Double)this.modeTbl.get(key);
            if (count > (double)prevCount) {
                String d = key;
                this.modeCost = (Double)((Object)d);
            }
            prevCount = (int)count;
            ++n2;
        }
    }

    public String showDistribution() {
        String buf = "";
        CostDistributionRpt rpt = new CostDistributionRpt(this.costDistribution);
        rpt.run();
        return buf;
    }

    public void setComputedProbabilityOfCompletionPercentage(double computedProbabilityOfCompletionPercentage) {
        this.computedProbabilityOfCompletionPercentage = computedProbabilityOfCompletionPercentage;
    }

    public double getComputedProbabilityOfCompletionPercentage() {
        return this.computedProbabilityOfCompletionPercentage;
    }

    public void setComputedAverageSlack(double computedAverageSlack) {
        this.computedAverageSlack = computedAverageSlack;
    }

    public double getComputedAverageSlack() {
        return this.averageSlack;
    }

    public void setComputedAverageTime(double computedAverageTime) {
        this.computedAverageTime = computedAverageTime;
    }

    public double getComputedAverageTime() {
        return this.computedAverageTime;
    }
}

