/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMap;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.ProbabilityDistribution;
import com.ibm.team.tempo.shared.client.TriangularEstimate;

public abstract class ImpactFunc
extends DojoObject {
    private ImpactFunc() {
    }

    public static double getVariance(ProbabilityDistribution pd) {
        return pd.getUpperbound() - pd.getLowerbound();
    }

    public static double getValue(ProbabilityDistribution pd) {
        double value = ImpactFunc.getVariance(pd);
        return value;
    }

    public static double computeImpact2(GraphNode graphNode, JSMap<GraphNode> graphNodeTbl) {
        double impactDbl;
        TriangularEstimate estimate = graphNode.getEstimate();
        if (!graphNode.isRandomVariate()) {
            impactDbl = 0.0;
        } else if (graphNode.getSuccessors().length == 0) {
            impactDbl = 0.0;
        } else {
            impactDbl = ImpactFunc.getValue(estimate.getPd());
            String[] successors = graphNode.getSuccessors();
            int i = 0;
            while (i < successors.length) {
                GraphNode successor = (GraphNode)((Object)graphNodeTbl.get(successors[i]));
                double successorImpact = ImpactFunc.computeImpact2(successor, graphNodeTbl);
                impactDbl += successorImpact / ((double)successors.length - 0.0);
                ++i;
            }
        }
        return impactDbl;
    }
}

