/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.tempo.shared.client.CostDistribution;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.MonteCarloGraphNode;
import com.ibm.team.tempo.shared.client.OptimizationResults;
import com.ibm.team.tempo.shared.client.OwnerScheduledGraph;
import com.ibm.team.tempo.shared.client.ScheduleByOwner;

public class GraphOptimization
extends DojoObject {
    private JSMap<GraphNode[]> ownerGraphNodeTbl = null;
    private OwnerScheduledGraph graph = null;
    private GraphNode[] scheduleResult = null;
    private double overallCost = 0.0;

    public GraphOptimization(ScheduleByOwner schedule) {
        this.graph = schedule.getGraph();
        this.scheduleResult = schedule.getScheduleResult();
        this.ownerGraphNodeTbl = this.graph.getOwnerGraphNodeTbl();
    }

    public OptimizationResults simulate(int n) {
        return this.__doSimulate(n, false, true);
    }

    public double getOverallCost() {
        return this.overallCost;
    }

    public int getLookupCount(OwnerScheduledGraph graph) {
        return graph.getLookupCount();
    }

    private OptimizationResults __doSimulate(int n, boolean showNodes, boolean showNodeDistributions) {
        JSMap<MonteCarloGraphNode> monteCarloNodeTbl = this.__populateMonteCarloNodes(this.graph.getGraphNodeTbl(), n, showNodeDistributions);
        CostDistribution costDistribution = new CostDistribution(n, null);
        double cost = 0.0;
        int lookupCount = 0;
        int i = 0;
        while (i < n) {
            this.overallCost = 0.0;
            this.graph.resetNodes();
            this.graph.run();
            if (this.scheduleResult == null) {
                this.__updateGraphMetrics(this.graph, monteCarloNodeTbl);
            } else if (this.ownerGraphNodeTbl == null) {
                this.__updateSimpleScheduledMetrics(this.scheduleResult, monteCarloNodeTbl);
            } else {
                this.__updateOwnerScheduledMetrics(monteCarloNodeTbl, this.ownerGraphNodeTbl);
            }
            this.__updateCriticalPathNodeCount(this.graph, monteCarloNodeTbl);
            cost = this.graph.getCritPathTotalCost();
            costDistribution.update(cost);
            lookupCount += this.getLookupCount(this.graph);
            if (showNodes) {
                this.graph.show();
            }
            ++i;
        }
        OptimizationResults results = new OptimizationResults(costDistribution, lookupCount);
        results.setMonteCarloNodeTbl(monteCarloNodeTbl);
        return results;
    }

    public JSMap<MonteCarloGraphNode> __populateMonteCarloNodes(JSMap<GraphNode> graphNodeTbl, int n, boolean showNodeDistributions) {
        JSMap monteCarloNodeTbl = new JSMap();
        String[] stringArray = graphNodeTbl.keys();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String key = stringArray[n3];
            monteCarloNodeTbl.put(key, (Object)new MonteCarloGraphNode((GraphNode)((Object)graphNodeTbl.get(key)), n, showNodeDistributions));
            ++n3;
        }
        return monteCarloNodeTbl;
    }

    public void __updateCriticalPathNodeCount(OwnerScheduledGraph graph, JSMap<MonteCarloGraphNode> monteCarloNodeTbl) {
        GraphNode graphNode = graph.getCriticalPathTailNode();
        while (graphNode != null) {
            MonteCarloGraphNode monteCarloGraphNode = (MonteCarloGraphNode)((Object)monteCarloNodeTbl.get(graphNode.getId()));
            monteCarloGraphNode.incrementOnCritPathCount();
            graphNode = graphNode.getConstraintPredecessor();
        }
    }

    public void __updateGraphMetrics(OwnerScheduledGraph graph, JSMap<MonteCarloGraphNode> monteCarloNodeTbl) {
        JSMap<GraphNode> graphNodeTbl = graph.getGraphNodeTbl();
        String[] stringArray = graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeId = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)graphNodeTbl.get(nodeId));
            MonteCarloGraphNode monteCarloGraphNode = (MonteCarloGraphNode)((Object)monteCarloNodeTbl.get(nodeId));
            this.__updateMetrics(graphNode, monteCarloGraphNode);
            ++n2;
        }
    }

    public void __updateSimpleScheduledMetrics(GraphNode[] scheduleResult, JSMap<MonteCarloGraphNode> monteCarloNodeTbl) {
        int i = 0;
        while (i < scheduleResult.length) {
            GraphNode graphNode = scheduleResult[i];
            MonteCarloGraphNode monteCarloGraphNode = (MonteCarloGraphNode)((Object)monteCarloNodeTbl.get(graphNode.getId()));
            this.__updateMetrics(graphNode, monteCarloGraphNode);
            this.overallCost += graphNode.getTotalCost();
            monteCarloGraphNode.updateAbleToCompleteCount(this.overallCost, graphNode.getTargetCost());
            monteCarloGraphNode.updateEffectiveAbilityToCompleteCount(this.overallCost, graphNode.getEffectiveTargetCost());
            ++i;
        }
    }

    public void __updateOwnerScheduledMetrics(JSMap<MonteCarloGraphNode> monteCarloNodeTbl, JSMap<GraphNode[]> ownerGraphNodeTbl) {
        double overallCost = 0.0;
        String[] stringArray = ownerGraphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ownerId = stringArray[n2];
            double overallUserCost = 0.0;
            GraphNode[] ownerNodeLst = (GraphNode[])ownerGraphNodeTbl.get(ownerId);
            int j = 0;
            while (j < ownerNodeLst.length) {
                GraphNode graphNode = ownerNodeLst[j];
                MonteCarloGraphNode monteCarloGraphNode = (MonteCarloGraphNode)((Object)monteCarloNodeTbl.get(graphNode.getId()));
                this.__updateMetrics(graphNode, monteCarloGraphNode);
                overallUserCost = overallUserCost + graphNode.getTotalCost() + graphNode.getSlack();
                monteCarloGraphNode.updateAbleToCompleteCount(overallUserCost, graphNode.getTargetCost());
                monteCarloGraphNode.updateEffectiveAbilityToCompleteCount(overallUserCost, graphNode.getEffectiveTargetCost());
                ++j;
            }
            overallCost = JSMath.max((double)overallCost, (double)overallUserCost);
            ++n2;
        }
    }

    public void __updateMetrics(GraphNode graphNode, MonteCarloGraphNode monteCarloGraphNode) {
        monteCarloGraphNode.updateCostFields(graphNode.getCost());
        monteCarloGraphNode.updateSlack(graphNode.getSlack());
        monteCarloGraphNode.updateSlackPlusTotCost(graphNode.getTotalCost() + graphNode.getSlack());
    }
}

