/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.apt.api.client.IPlanItem;
import com.ibm.team.tempo.shared.client.TriangularEstimate;

public class GraphNode
extends DojoObject {
    private TriangularEstimate estimate = null;
    private double startCost = 0.0;
    private double cost = 0.0;
    private double actualCost = 0.0;
    private double cumulativeCost = 0.0;
    private double slack = 0.0;
    private double impact = 0.0;
    private double targetCost = 0.0;
    private double effectiveTargetCost = 0.0;
    private double targetCompletionCost = 0.0;
    private String owner = "";
    private boolean isRandomVariateFlag = false;
    private boolean isProcessedNodeFlag = false;
    private GraphNode constraintPredecessor = null;
    private int priority = 0;
    private int unprocessedPredecessors = 0;
    private String[] successors = null;
    private GraphNode[] predecessors = null;
    private String id;
    private IPlanItem parent;

    public GraphNode(String id, Object estimateOrActualCost) {
        this.id = id;
        if (!(estimateOrActualCost instanceof TriangularEstimate)) {
            Double actualCost = (Double)estimateOrActualCost;
            this.setActualCost(actualCost);
        } else {
            TriangularEstimate estimate = (TriangularEstimate)((Object)estimateOrActualCost);
            this.setEstimate(estimate);
        }
        this.parent = null;
    }

    public IPlanItem getParent() {
        return this.parent;
    }

    public void setParent(IPlanItem parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isProcessedNode() {
        return this.isProcessedNodeFlag;
    }

    public void setProcessedNode(boolean isProcessedNode) {
        this.isProcessedNodeFlag = isProcessedNode;
    }

    public double getStartCost() {
        return this.startCost;
    }

    public void setStartCost(double startCost) {
        this.startCost = startCost;
    }

    public double getSlack() {
        return this.slack;
    }

    public void setSlack(double slack) {
        this.slack = slack;
    }

    public double getImpact() {
        return this.impact;
    }

    public void setImpact(double impact) {
        this.impact = impact;
    }

    public double getCumulativeCost() {
        return this.cumulativeCost;
    }

    public void setCumulativeCost(double cumulativeCost) {
        this.cumulativeCost = cumulativeCost;
    }

    public double getTargetCost() {
        return this.targetCost;
    }

    public void setTargetCost(double targetCost) {
        this.targetCost = targetCost;
    }

    public double getEffectiveTargetCost() {
        return this.effectiveTargetCost;
    }

    public void setEffectiveTargetCost(double effectiveTargetCost) {
        this.effectiveTargetCost = effectiveTargetCost;
    }

    public double getTargetCompletionCost() {
        return this.targetCompletionCost;
    }

    public GraphNode getConstraintPredecessor() {
        return this.constraintPredecessor;
    }

    public void setConstraintPredecessor(GraphNode constraintPredecessor) {
        this.constraintPredecessor = constraintPredecessor;
    }

    public double getCost() {
        return this.cost;
    }

    public double getActualCost() {
        return this.actualCost;
    }

    public void setActualCost(double actualCost) {
        this.actualCost = actualCost;
    }

    public double getTotalCost() {
        return this.getStartCost() + this.getCost();
    }

    public int getUnprocessedPredecessors() {
        return this.unprocessedPredecessors;
    }

    public void setUnprocessedPredecessors(int unprocessedPredecessors) {
        this.unprocessedPredecessors = unprocessedPredecessors;
    }

    public void decrementUnprocessedPredecessors() {
        --this.unprocessedPredecessors;
    }

    public void addSuccessor(String successor) {
        if (successor != null) {
            JSArrays.push((Object[])this.getSuccessors(), (Object)successor);
        }
    }

    public String[] getSuccessors() {
        if (this.successors == null) {
            this.successors = new String[0];
        }
        return this.successors;
    }

    public void addPredecessor(GraphNode predecessor) {
        if (predecessor != null) {
            JSArrays.push((Object[])this.getPredecessors(), (Object)((Object)predecessor));
        }
    }

    public GraphNode[] getPredecessors() {
        if (this.predecessors == null) {
            this.predecessors = new GraphNode[0];
        }
        return this.predecessors;
    }

    public void clearPredecessors() {
        this.predecessors = null;
    }

    public int getNrOfPredecessors() {
        return this.getPredecessors().length;
    }

    public boolean isRandomVariate() {
        return this.isRandomVariateFlag;
    }

    public void setSuccessors(String[] successors) {
        this.successors = successors;
    }

    public TriangularEstimate getEstimate() {
        return this.estimate;
    }

    public void setEstimate(TriangularEstimate estimate) {
        this.estimate = estimate;
        this.isRandomVariateFlag = true;
    }

    public String toString() {
        return this.getId();
    }

    public String show(boolean withSlack) {
        String buf = "";
        buf = String.valueOf(buf) + " Id=" + this.getId();
        buf = String.valueOf(buf) + " owner=" + this.getOwner();
        buf = String.valueOf(buf) + " estimate=[" + (Object)((Object)this.estimate) + "]";
        buf = String.valueOf(buf) + " startCost=" + this.getStartCost();
        buf = String.valueOf(buf) + " cost=" + JSMath.round((double)this.getCost());
        buf = String.valueOf(buf) + " impact=" + this.impact;
        buf = String.valueOf(buf) + " cumulativeCost=" + JSMath.round((double)this.getCumulativeCost());
        if (withSlack) {
            buf = String.valueOf(buf) + " slack=" + this.getSlack();
        }
        buf = String.valueOf(buf) + " predecessors=[" + this.getPredecessors() + "]";
        buf = String.valueOf(buf) + " successors=[" + this.getSuccessors() + "]";
        return buf;
    }

    public void reset() {
        this.setSlack(0.0);
        this.setCumulativeCost(0.0);
        this.setUnprocessedPredecessors(0);
        this.setProcessedNode(false);
        this.constraintPredecessor = null;
    }

    public void computeCost() {
        if (this.actualCost > 0.0) {
            this.cost = this.actualCost;
        } else {
            this.estimate.computeCost();
            this.cost = this.estimate.getCost();
        }
    }
}

