/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.base.dojo;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMap;
import com.ibm.team.tempo.shared.client.GraphNode;
import com.ibm.team.tempo.shared.client.NbTraverser;

public class Graph
extends DojoObject {
    private GraphNode[] origNodeLst = new GraphNode[0];
    private JSMap<GraphNode> graphNodeTbl = new JSMap();
    private GraphNode[] headNodeLst = new GraphNode[0];
    private String[] successorIdLst = new String[0];
    private NbTraverser traverser = new NbTraverser();
    private GraphNode criticalPathTailNode = null;
    private boolean fisRandomVariate = false;
    private boolean isSuccessorValidated = false;
    private double critPathTotalCost = 0.0;
    private int lookupCount = 0;

    public void add(Object graphNodeOrLst) {
        GraphNode[] graphNodeLst = null;
        if (graphNodeOrLst instanceof GraphNode) {
            GraphNode node = (GraphNode)((Object)graphNodeOrLst);
            graphNodeLst = new GraphNode[]{};
            JSArrays.push((Object[])graphNodeLst, (Object)((Object)node));
        } else {
            graphNodeLst = (GraphNode[])graphNodeOrLst;
        }
        int i = 0;
        while (i < graphNodeLst.length) {
            String[] successorLst;
            GraphNode graphNode = graphNodeLst[i];
            this.graphNodeTbl.put(graphNode.getId(), (Object)graphNode);
            JSArrays.push((Object[])this.origNodeLst, (Object)((Object)graphNode));
            if (graphNode.isRandomVariate()) {
                this.setRandomVariate(true);
            }
            if ((successorLst = graphNode.getSuccessors()) != null) {
                int s = 0;
                while (s < successorLst.length) {
                    String successorId = successorLst[s];
                    if (dojo.indexOf((Object[])this.successorIdLst, (Object)successorId) < 0) {
                        JSArrays.push((Object[])this.successorIdLst, (Object)successorId);
                    }
                    ++s;
                }
            }
            ++i;
        }
        this.isSuccessorValidated = false;
    }

    public GraphNode[] getOrigNodeLst() {
        return this.origNodeLst;
    }

    public JSMap<GraphNode> getGraphNodeTbl() {
        return this.graphNodeTbl;
    }

    public GraphNode[] getCriticalPath() {
        GraphNode[] criticalPathLst = new GraphNode[]{};
        GraphNode[] criticalPathBackwardLst = new GraphNode[]{};
        GraphNode graphNode = this.criticalPathTailNode;
        while (graphNode != null) {
            JSArrays.push((Object[])criticalPathBackwardLst, (Object)((Object)graphNode));
            graphNode = graphNode.getConstraintPredecessor();
        }
        int i = criticalPathBackwardLst.length - 1;
        while (i == 0) {
            JSArrays.push((Object[])criticalPathLst, (Object)((Object)criticalPathBackwardLst[i]));
            --i;
        }
        return criticalPathLst;
    }

    public double getCritPathTotalCost() {
        return this.critPathTotalCost;
    }

    public boolean isRandomVariate() {
        return this.fisRandomVariate;
    }

    public GraphNode getCriticalPathTailNode() {
        return this.criticalPathTailNode;
    }

    public void run() {
        this.run_graph(null);
    }

    public void resetSuccessorValidated() {
        this.isSuccessorValidated = false;
    }

    public void accept(NbTraverser traverser) {
        this.traverser = traverser;
    }

    public int getLookupCount() {
        return this.lookupCount;
    }

    public void resetNodes() {
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            ((GraphNode)((Object)this.graphNodeTbl.get(key))).reset();
            ++n2;
        }
    }

    public GraphNode[] getHeadNodes() {
        return this.headNodeLst;
    }

    public void buildHeadNodeLst() {
        if (this.headNodeLst.length > 0) {
            return;
        }
        this.headNodeLst = new GraphNode[0];
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)this.graphNodeTbl.get(key));
            if (dojo.indexOf((Object[])this.successorIdLst, (Object)graphNode.getId()) < 0) {
                JSArrays.push((Object[])this.headNodeLst, (Object)((Object)graphNode));
            }
            ++n2;
        }
    }

    public void initUnproccessedPredecessorCount() {
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)this.graphNodeTbl.get(key));
            graphNode.setUnprocessedPredecessors(graphNode.getNrOfPredecessors());
            ++n2;
        }
    }

    public void initPredecessorCount() {
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)this.graphNodeTbl.get(key));
            String[] successors = graphNode.getSuccessors();
            int j = 0;
            while (j < successors.length) {
                String successorId = successors[j];
                GraphNode successor = (GraphNode)((Object)this.graphNodeTbl.get(successorId));
                successor.addPredecessor(graphNode);
                ++j;
            }
            ++n2;
        }
    }

    public void show() {
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)this.graphNodeTbl.get(key));
            graphNode.show(this.traverser.getOwnerNodeTbl() != null);
            ++n2;
        }
    }

    public String toString() {
        String str = "";
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)this.graphNodeTbl.get(key));
            str = String.valueOf(str) + graphNode.show(this.traverser.getOwnerNodeTbl() != null);
            ++n2;
        }
        return str;
    }

    public void run_graph(JSMap<GraphNode[]> ownerGraphNodeTbl) {
        if (!this.isSuccessorValidated) {
            this.isSuccessorValidated = true;
            this.initPredecessorCount();
        }
        this.computeCost();
        this.buildHeadNodeLst();
        this.traverser.run(this, ownerGraphNodeTbl);
        this.setCritPathTotalCost(this.traverser.getCost());
        this.setCritPathTailNode(this.traverser.getCriticalPathTailNode());
        this.setLookupCount(this.traverser.getLookupCount());
    }

    public void computeCost() {
        String[] stringArray = this.graphNodeTbl.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            GraphNode graphNode = (GraphNode)((Object)this.graphNodeTbl.get(key));
            graphNode.computeCost();
            ++n2;
        }
    }

    public void setRandomVariate(boolean isRandomVariate) {
        this.fisRandomVariate = isRandomVariate;
    }

    public void setCritPathTotalCost(double critPathTotalCost) {
        this.critPathTotalCost = critPathTotalCost;
    }

    public void setLookupCount(int lookupCount) {
        this.lookupCount = lookupCount;
    }

    public void setCritPathTailNode(GraphNode criticalPathTailNode) {
        this.criticalPathTailNode = criticalPathTailNode;
    }

    public void validateSuccessors() {
    }
}

