/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojo.util.JSNumbers;
import com.ibm.team.tempo.shared.client.ACostDistributionRpt;
import com.ibm.team.tempo.shared.client.CostCumulativePctDistributionRpt;

public class CostDistribution
extends DojoObject {
    private static final int MAX_MIDPT_FRACTIONAL_DIGITS = 10;
    private int NR_OF_DATA_PTS = 0;
    private int NR_OF_BINS = 100;
    private int[] distribution;
    private double[] binCeiling;
    private double[] data;
    private double[] moments;
    private double binRange = 0.0;
    private double minCost = 0.0;
    private double maxCost = 0.0;
    private double varCost = 0.0;
    private double stdCost = 0.0;
    private double totCost = 0.0;
    private int totCount = 0;
    private int nrOfDataPts = 0;
    private int maxCount = 0;
    private int midpointFractionalDigits = 0;

    public CostDistribution(int nrOfIterations, Integer binCount) {
        this.NR_OF_DATA_PTS = nrOfIterations;
        this.NR_OF_BINS = binCount != null ? binCount : this.NR_OF_BINS;
        this.data = new double[0];
        this.distribution = new int[0];
        this.binCeiling = new double[0];
        this.moments = new double[0];
    }

    public void update(double cost) {
        this.data[this.nrOfDataPts++] = cost;
        this.minCost = JSMath.min((double)cost, (double)this.minCost);
        this.maxCost = JSMath.max((double)cost, (double)this.maxCost);
        this.totCost += cost;
        if (this.nrOfDataPts == this.NR_OF_DATA_PTS) {
            this.buildBinCeilings();
            this.buildDistribution();
            this.computeMaxCount();
            this.computeCostSTD();
            this.computeMoments();
        }
    }

    public int getN() {
        return this.NR_OF_DATA_PTS;
    }

    public int getNrOfBins() {
        return this.NR_OF_BINS;
    }

    public int getCountOfBin(int binIndex) {
        return this.distribution[binIndex];
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public double getMinCost() {
        return this.minCost;
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public double getAvgCost() {
        return this.totCost / (0.0 + (double)this.NR_OF_DATA_PTS);
    }

    public double getVarCost() {
        return this.varCost;
    }

    public double getStdCost() {
        return this.stdCost;
    }

    public void showCumulativePct() {
        CostCumulativePctDistributionRpt rpt = new CostCumulativePctDistributionRpt(this);
        rpt.run();
    }

    public double[] getMoments() {
        return this.moments;
    }

    public double getBinPercent(int binIndex) {
        return ((double)this.distribution[binIndex] + 0.0) / ((double)this.NR_OF_DATA_PTS * 100.0);
    }

    public double getMidpoint(int binIndex) {
        return this.binCeiling[binIndex] - this.binRange / 2.0;
    }

    public String getMidpointStr(int binIndex) {
        double midpoint = this.getMidpoint(binIndex);
        int fractionalDigits = this.getMidpointFractionalDigits();
        if (fractionalDigits > 0 || this.binRange == 1.0) {
            ++fractionalDigits;
        }
        return ACostDistributionRpt.format(midpoint, fractionalDigits).toString();
    }

    public double[] getData() {
        return this.data;
    }

    public int getMidpointFractionalDigits() {
        return this.midpointFractionalDigits;
    }

    public void buildBinCeilings() {
        boolean isBinRangeAdequate = false;
        double prevBinCeiling = 0.0;
        int j = 0;
        while (j < 8) {
            this.binRange = (this.getMaxCost() - this.getMinCost()) / (0.0 + (double)this.NR_OF_BINS);
            if (this.binRange == 0.0) {
                this.binRange = this.getMaxCost() / (0.0 + (double)this.NR_OF_BINS);
            }
            if (this.binRange == 0.0 && this.midpointFractionalDigits == 10 && this.binRange >= 1.0) {
                this.binRange = JSNumbers.parseFloat((String)ACostDistributionRpt.format(this.binRange, this.midpointFractionalDigits));
            }
            int i = 0;
            while (i < this.NR_OF_BINS) {
                this.binCeiling[i] = this.getMaxCost() - this.binRange * ((double)this.NR_OF_BINS - ((double)i + 1.0));
                if (prevBinCeiling == this.binCeiling[i] || this.getMaxCost() - this.getMinCost() > 0.0 && this.binCeiling[i] < this.getMinCost()) {
                    isBinRangeAdequate = false;
                    ++this.midpointFractionalDigits;
                    break;
                }
                prevBinCeiling = this.binCeiling[i];
                isBinRangeAdequate = true;
                ++i;
            }
            ++j;
        }
    }

    public void buildDistribution() {
        double cost = 0.0;
        int i = 0;
        while (i < this.NR_OF_BINS) {
            this.distribution[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.NR_OF_DATA_PTS) {
            cost = this.data[i];
            int j = 0;
            while (j < this.NR_OF_BINS) {
                if (cost <= this.binCeiling[j]) {
                    int n = j;
                    this.distribution[n] = this.distribution[n] + 1;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void computeMaxCount() {
        int i = 0;
        while (i < this.NR_OF_BINS) {
            this.maxCount = JSMath.max((int)this.distribution[i], (int)this.maxCount);
            this.totCount += this.distribution[i];
            ++i;
        }
    }

    public void computeCostSTD() {
        double diffSqrSum = 0.0;
        double diff = 0.0;
        int i = 0;
        while (i < this.NR_OF_DATA_PTS) {
            diff = this.data[i] - this.getAvgCost();
            diffSqrSum += JSMath.pow((double)diff, (double)2.0);
            ++i;
        }
        this.varCost = diffSqrSum / ((double)this.NR_OF_DATA_PTS - 1.0);
        this.stdCost = JSMath.sqrt((double)this.varCost);
    }

    public void computeMoments() {
        int i = 0;
        while (i < this.NR_OF_DATA_PTS) {
            this.moments[0] = this.moments[0] + 1.0;
            this.moments[1] = this.moments[1] + this.data[i];
            this.moments[2] = this.moments[2] + this.data[i] * this.data[i];
            this.moments[3] = this.moments[3] + this.data[i] * this.data[i] * this.data[i];
            ++i;
        }
    }
}

