/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.tempo.shared.client;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojo.util.JSNumbers;
import com.ibm.team.tempo.shared.client.CostDistribution;

public class ACostDistributionRpt
extends DojoObject {
    private static final String NEW_LINE = "\n";
    private static final String BLANK = " ";
    private static final int MIDPOINT_SIZE = 8;
    private String rptBuf = "";
    private String fillBuf = "";
    private int scaleFactor = 0;
    private int dataLabelSize = 0;
    protected CostDistribution dist;

    public static String format(double value, int fractionalDigits) {
        return JSNumbers.toFixed((double)value, (int)fractionalDigits);
    }

    public ACostDistributionRpt(CostDistribution dist) {
        this.dist = dist;
    }

    public int getScaleFactor(int maxCount) {
        double scaledCount;
        int scaleFactor = 0;
        double maxPoints = 50.0;
        while ((scaledCount = (double)JSMath.round((double)(maxCount / ++scaleFactor))) > maxPoints) {
        }
        return scaleFactor;
    }

    public void addHeader(String title, String dataLabel, int maxCount) {
        String scaleFactorMsg = "";
        this.dataLabelSize = dataLabel.length() + 1;
        this.scaleFactor = this.getScaleFactor(maxCount);
        if (this.scaleFactor > 1) {
            scaleFactorMsg = this.getScaleFactorMsg(this.scaleFactor);
        }
        this.rptBuf = "";
        this.rptBuf = String.valueOf(this.rptBuf) + "\n\n" + title;
        this.rptBuf = String.valueOf(this.rptBuf) + "\nMidpoint  " + dataLabel + scaleFactorMsg;
    }

    public void addDetail(String midpoint, double data, int fractionalDigits) {
        String unit = "";
        unit = ACostDistributionRpt.format(data, fractionalDigits);
        this.rptBuf = String.valueOf(this.rptBuf) + NEW_LINE;
        this.rptBuf = String.valueOf(this.rptBuf) + this.getFill(8 - midpoint.length()) + midpoint;
        this.rptBuf = String.valueOf(this.rptBuf) + BLANK;
        this.rptBuf = String.valueOf(this.rptBuf) + this.getFill(this.dataLabelSize - unit.length()) + unit;
        this.rptBuf = String.valueOf(this.rptBuf) + BLANK;
        double val = JSMath.round((double)(data / (double)this.scaleFactor));
        this.rptBuf = String.valueOf(this.rptBuf) + this.repeat("*", (int)val);
    }

    public void addUnivariateStats() {
        this.rptBuf = String.valueOf(this.rptBuf) + "\n\nUnivariate Statistics";
        this.rptBuf = String.valueOf(this.rptBuf) + "\n  Number of data points = " + this.dist.getN();
        this.rptBuf = String.valueOf(this.rptBuf) + "\n  Minimum  = " + ACostDistributionRpt.format(this.dist.getMinCost(), 2);
        this.rptBuf = String.valueOf(this.rptBuf) + "\n  Average  = " + ACostDistributionRpt.format(this.dist.getAvgCost(), 2);
        this.rptBuf = String.valueOf(this.rptBuf) + "\n  Maximum  = " + ACostDistributionRpt.format(this.dist.getMaxCost(), 2);
        this.rptBuf = String.valueOf(this.rptBuf) + "\n  Variance = " + ACostDistributionRpt.format(this.dist.getVarCost(), 2);
        this.rptBuf = String.valueOf(this.rptBuf) + "\n  Standard deviation = " + ACostDistributionRpt.format(this.dist.getStdCost(), 2);
    }

    public String getScaleFactorMsg(int scaleFactor) {
        return ", where each '*' represents " + scaleFactor + " data points.";
    }

    public String getFill(int size) {
        return this.repeat(BLANK, size);
    }

    public String repeat(String value, int size) {
        this.fillBuf = "";
        int i = 0;
        while (i < size) {
            this.fillBuf = String.valueOf(this.fillBuf) + value;
            ++i;
        }
        return this.fillBuf;
    }

    public void print() {
    }

    public String getRptText() {
        return this.rptBuf;
    }
}

