/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.trs.common;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ITeamModelledRestService;
import com.ibm.team.scm.trs.common.internal.rest.dto.PublishedItemListDTO;
import com.ibm.team.scm.trs.common.internal.rest.dto.TrsStatusDTO;
import java.util.Collection;

public interface IScmTrsRestService
extends ITeamModelledRestService {
    public static final String EXPLICIT_PUBLISH_KEY = "ScmTrsRestService.publish";
    public static final String VALIDATION_REPAIR = "ScmTrsTestService.validation.repair";
    public static final String VALIDATE_ITEM_RESULT_TYPE = "com.ibm.team.scm.trs.validateItem";
    public static final int TRS_PUBLICATION_STATUS_NOT_PUBLISHED = 0;
    public static final int TRS_PUBLICATION_STATUS_PUBLISHED = 1;
    public static final int TRS_PUBLICATION_STATUS_PUBLISHED_INDIRECTLY = 2;

    public void assertPublishPermission(ParmsArtifacts var1) throws TeamRepositoryException;

    public String[] postPublishArtifacts(ParmsArtifacts var1) throws TeamRepositoryException;

    public void postUnpublishArtifacts(ParmsArtifacts var1) throws TeamRepositoryException;

    public void postUnpublishAllProjectAreaResources(ParmsArtifacts var1) throws TeamRepositoryException;

    public String[] postValidateArtifacts(ParmsArtifacts var1) throws TeamRepositoryException;

    public PublishedItemListDTO postQueryPublishedItems(ParmsPublishedItems var1) throws TeamRepositoryException;

    public TrsStatusDTO getTrsStatus(ParmsGetTrsStatus var1) throws TeamRepositoryException;

    public static final class ParmsArtifacts
    implements IParameterWrapper {
        public String[] itemNamespaces;
        public String[] itemTypes;
        public String[] itemIds;
        public boolean repair;
        public boolean forcePublish = false;

        public ParmsArtifacts() {
        }

        public ParmsArtifacts(IItemHandle item) {
            this.itemIds = new String[1];
            this.itemNamespaces = new String[1];
            this.itemTypes = new String[1];
            this.itemIds[0] = item.getItemId().getUuidValue();
            this.itemNamespaces[0] = item.getItemType().getNamespaceURI();
            this.itemTypes[0] = item.getItemType().getName();
        }

        public ParmsArtifacts(Collection<IItemHandle> items) {
            this.itemIds = new String[items.size()];
            this.itemNamespaces = new String[items.size()];
            this.itemTypes = new String[items.size()];
            int i = 0;
            for (IItemHandle item : items) {
                this.itemIds[i] = item.getItemId().getUuidValue();
                this.itemNamespaces[i] = item.getItemType().getNamespaceURI();
                this.itemTypes[i] = item.getItemType().getName();
                ++i;
            }
        }

        public void validate() {
            if (this.itemNamespaces == null) {
                throw new IllegalStateException();
            }
            if (this.itemTypes == null) {
                throw new IllegalStateException();
            }
            if (this.itemIds == null) {
                throw new IllegalStateException();
            }
            int size = this.itemIds.length;
            if (this.itemTypes.length != size) {
                throw new IllegalStateException();
            }
            if (this.itemNamespaces.length != size) {
                throw new IllegalStateException();
            }
        }
    }

    public static final class ParmsGetTrsStatus
    implements IParameterWrapper {
        public String resourceUri;
    }

    public static final class ParmsPublishedItems
    implements IParameterWrapper {
        public String itemType;
        public String nameFilter;
        public String pageDescriptor;
        public int maxResultSize;
    }
}

