/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.subclipse.ui.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import com.ibm.team.scm.svn.subclipse.ui.internal.SubclipseLogEntry;
import com.ibm.team.scm.svn.subclipse.ui.internal.SubclipseMessages;
import java.text.ParseException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SubclipseWorkItemAdapter
extends SVNWorkItemAdapter {
    private static SubclipseWorkItemAdapter instance;

    public static synchronized SubclipseWorkItemAdapter getInstance() {
        if (instance == null) {
            instance = new SubclipseWorkItemAdapter();
        }
        return instance;
    }

    public IStatus showRevision(IWorkbenchPage page, String repoUrl, String revision) {
        try {
            ISVNRemoteFolder folder = this.getRemoteFolder(repoUrl, revision);
            TeamUI.showHistoryFor((IWorkbenchPage)page, (Object)folder, null);
            return Status.OK_STATUS;
        }
        catch (SVNException e) {
            return new Status(4, "com.ibm.team.scm.svn.subclipse.ui", 0, NLS.bind((String)SubclipseMessages.SubclipseWorkItemHyperlinkHandler_0, (Object)revision, (Object)repoUrl), (Throwable)e);
        }
        catch (ParseException e) {
            return new Status(4, "com.ibm.team.scm.svn.subclipse.ui", 0, NLS.bind((String)SubclipseMessages.SubclipseWorkItemHyperlinkHandler_1, (Object)revision, (Object)repoUrl), (Throwable)e);
        }
    }

    public SvnLogEntry asLogEntry(Object revision) {
        return SubclipseLogEntry.createFor(revision);
    }

    public SvnBugtraqProperties getBugTrackingProperties(IProject project) throws FileSystemException {
        try {
            ProjectProperties properties = ProjectProperties.getProjectProperties((IResource)project);
            return SubclipseLogEntry.asBugtraqProperties(properties);
        }
        catch (SVNException e) {
            throw new FileSystemException(NLS.bind((String)SubclipseMessages.SubclipseWorkItemAdapter_0, (Object)project.getName()), (Throwable)e);
        }
    }

    public void setBugTrackingProperties(IProject project, SvnBugtraqProperties properties) throws FileSystemException {
        try {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)project);
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                svnResource.setSvnProperty(key, value, false);
            }
        }
        catch (SVNException e) {
            throw new FileSystemException(NLS.bind((String)SubclipseMessages.SubclipseWorkItemAdapter_1, (Object)project.getName()), (Throwable)e);
        }
    }

    public void removeBugTrackingProperties(IProject project) throws FileSystemException {
        try {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)project);
            this.deleteSvnProperty(svnResource, "bugtraq:url");
            this.deleteSvnProperty(svnResource, "bugtraq:label");
            this.deleteSvnProperty(svnResource, "bugtraq:message");
            this.deleteSvnProperty(svnResource, "bugtraq:append");
            this.deleteSvnProperty(svnResource, "bugtraq:warnifnoissue");
            this.deleteSvnProperty(svnResource, "bugtraq:number");
            this.deleteSvnProperty(svnResource, "bugtraq:logregex");
        }
        catch (SVNException e) {
            throw new FileSystemException(NLS.bind((String)SubclipseMessages.SubclipseWorkItemAdapter_2, (Object)project.getName()), (Throwable)e);
        }
    }

    private void deleteSvnProperty(ISVNLocalResource svnResource, String property) throws SVNException {
        try {
            svnResource.deleteSvnProperty(property, false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ISVNRemoteFolder getRemoteFolder(String repoUrl, String revision) throws SVNException, ParseException {
        ISVNRepositoryLocation repository = SVNProviderPlugin.getPlugin().getRepository(repoUrl);
        SVNRevision svnRevision = null;
        SVNRevision.Number lastChangeRevision = null;
        if (revision == null) {
            svnRevision = SVNRevision.HEAD;
        } else {
            svnRevision = SVNRevision.getRevision((String)revision);
            lastChangeRevision = (SVNRevision.Number)svnRevision;
        }
        RemoteFolder folder = new RemoteFolder(null, repository, repository.getUrl(), svnRevision, lastChangeRevision, null, null);
        return folder;
    }
}

