/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.subclipse.ui.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.LocalLinkUpdateOperation;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import com.ibm.team.scm.svn.subclipse.ui.internal.SubclipseMessages;
import com.ibm.team.scm.svn.subclipse.ui.internal.SubclipseWorkItemAdapter;
import java.text.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SubclipseLocalLinkUpdateOperation
extends LocalLinkUpdateOperation {
    public SubclipseLocalLinkUpdateOperation(ITeamRepository teamRepository, String url, long startingRevision) {
        super(teamRepository, url, startingRevision, (SVNWorkItemAdapter)SubclipseWorkItemAdapter.getInstance());
    }

    public void runLocalUpdate(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ISVNRemoteFolder remoteFolder = ((SubclipseWorkItemAdapter)this.getWorkItemAdapter()).getRemoteFolder(this.getUrl(), null);
            progress.subTask(NLS.bind((String)SubclipseMessages.SubclipseUpdateLinksOperation_0, (Object)this.getUrl(), (Object)Long.toString(this.getStartingRevision())));
            ISVNLogMessage[] logMessages = this.getLogMessages(remoteFolder, SVNRevision.HEAD, SVNRevision.HEAD, (SVNRevision)new SVNRevision.Number(this.getStartingRevision()), false, true, 0L);
            ILogEntry[] entries = LogEntry.createLogEntriesFrom((ISVNRemoteFolder)remoteFolder, (ISVNLogMessage[])logMessages, (Tags[])new Tags[logMessages.length]);
            progress.worked(40);
            progress.setWorkRemaining(entries.length * 10);
            ILogEntry[] iLogEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ILogEntry logEntry = iLogEntryArray[n2];
                this.createLinks(logEntry, logEntry.getComment(), (IProgressMonitor)progress.newChild(10));
                ++n2;
            }
            if (entries.length > 0) {
                this.setLatestRevision(entries[0].getRevision().getNumber());
            }
        }
        catch (SVNException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (ParseException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (TeamException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private ISVNLogMessage[] getLogMessages(ISVNRemoteFolder remoteFolder, SVNRevision peg, SVNRevision start, SVNRevision end, boolean stopOnCopy, boolean includeFilePaths, long limit) throws TeamException {
        return remoteFolder.getLogMessages(peg, start, end, stopOnCopy, includeFilePaths, limit, true);
    }

    private void createLinks(Object revision, String message, IProgressMonitor monitor) throws TeamRepositoryException {
        IURIReference uriReference = this.getWorkItemAdapter().getSelectedRevisionReference(revision);
        this.createLinks(uriReference, message, monitor);
    }
}

