/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class WorkItemHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        return this.isClientAvailable() && this.isSVNUri(uri);
    }

    protected abstract boolean isClientAvailable();

    private boolean isSVNUri(URI uri) {
        long revision;
        String revisionString = uri.getFragment();
        if (revisionString == null || revisionString.length() == 0) {
            return false;
        }
        try {
            revision = Long.parseLong(revisionString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return revision >= 0L && uri.getScheme().startsWith("svn+");
    }

    public IStatus open2(final URI uri, final ContextProvider provider, IProgressMonitor monitor) {
        UIJob job = new UIJob(SVNRCPMessages.WorkItemHyperlinkHandler_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    Shell shell = WorkItemHyperlinkHandler.this.getShell(provider.getUIContext());
                    URI repoUri = SvnLogEntry.getRepositoryUriFromRevisionUri((URI)uri);
                    return WorkItemHyperlinkHandler.this.showRevision(shell, repoUri.toString(), SvnLogEntry.getRevisionNumberFromRevisionUri((URI)uri), provider);
                }
                catch (URISyntaxException e) {
                    return StatusUtil.newStatus((Object)((Object)WorkItemHyperlinkHandler.this), (String)SVNRCPMessages.WorkItemHyperlinkHandler_1, (Throwable)e);
                }
                catch (FileSystemException e) {
                    return StatusUtil.newStatus((Object)((Object)WorkItemHyperlinkHandler.this), (String)SVNRCPMessages.WorkItemHyperlinkHandler_2, (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    protected abstract IStatus showRevision(Shell var1, String var2, String var3, ContextProvider var4) throws FileSystemException;

    private Shell getShell(Object context) {
        if (context instanceof Shell) {
            return (Shell)context;
        }
        if (context instanceof IWorkbenchPage) {
            return ((IWorkbenchPage)context).getActivePart().getSite().getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getShell();
    }

    public IWorkbenchPage getPage(Object context) {
        if (context instanceof IWorkbenchPage) {
            return (IWorkbenchPage)context;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    protected abstract SVNWorkItemAdapter getWorkItemAdapter();
}

