/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import com.ibm.team.workitem.ide.ui.internal.integration.WorkItemHyperLink;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public abstract class WorkItemHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final LinkDetector fgDetector = TextLinkDetectorManager.getDefault().createLinkDetector(false);

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<WorkItemHyperLink> matches = new ArrayList<WorkItemHyperLink>();
        try {
            List<URI> uris;
            SVNWorkItemAdapter workItemAdapter = this.getWorkItemAdapter();
            IDocument document = textViewer.getDocument();
            int line = document.getLineOfOffset(region.getOffset());
            int start = document.getLineOffset(line);
            int length = document.getLineLength(line);
            String text = document.get(start, length);
            List results = fgDetector.match(text);
            for (DetectedTextLink link : results) {
                if (start + link.getOffset() > region.getOffset() || start + link.getOffset() + link.getLength() <= region.getOffset()) continue;
                matches.add(new WorkItemHyperLink(link, start));
            }
            IResource resource = (IResource)this.getAdapter(IResource.class);
            if (resource != null && !(uris = workItemAdapter.getWorkItemUris(resource.getProject(), text)).isEmpty()) {
                matches.add(new WorkItemHyperLink((DetectedTextLink)new SVNWorkItemDetectedTextLink(start, length, uris), start));
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return matches.size() > 0 ? (IHyperlink[])matches.toArray(new WorkItemHyperLink[0]) : null;
    }

    protected abstract SVNWorkItemAdapter getWorkItemAdapter();

    private static class SVNWorkItemDetectedTextLink
    extends DetectedTextLink {
        private final List<URI> uris;

        public SVNWorkItemDetectedTextLink(int offset, int length, List<URI> uris) {
            super(offset, length);
            this.uris = uris;
        }

        public List createURIs() {
            return this.uris;
        }
    }
}

