/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.IOperationFactory;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.LocalLinkUpdateOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;

public class UpdateLinksOperation {
    private final String url;
    private final long startingRevision;
    private long latestRevision;
    private final ITeamRepository teamRepository;
    private final LocalLinkUpdateOperation localUpdateOperation;

    public UpdateLinksOperation(ITeamRepository teamRepository, String url, long startingRevision) {
        this.teamRepository = teamRepository;
        this.url = url;
        this.startingRevision = startingRevision;
        this.localUpdateOperation = this.internalGetLocalUpdateOperation();
    }

    public String getUrl() {
        return this.url;
    }

    public long getStartingRevision() {
        return this.startingRevision;
    }

    public void runLocalUpdate(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.localUpdateOperation != null) {
            this.localUpdateOperation.runLocalUpdate(monitor);
            this.setLatestRevision(this.localUpdateOperation.getLatestRevision());
        }
    }

    public long getLatestRevision() {
        return this.latestRevision;
    }

    public void setLatestRevision(long latestRevision) {
        this.latestRevision = latestRevision;
    }

    private LocalLinkUpdateOperation internalGetLocalUpdateOperation() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.ibm.team.scm.svn.rcp.ui", "localLinkUpdateHandler");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement ce = elements[i];
            try {
                Object ee = ce.createExecutableExtension("class");
                if (ee instanceof IOperationFactory) {
                    return ((IOperationFactory)ee).createLocalLinkUpdateOperation(this.teamRepository, this.url, this.startingRevision);
                }
            }
            catch (CoreException coreException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public LocalLinkUpdateOperation getLocalUpdateOperation() {
        return this.localUpdateOperation;
    }

    public ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }
}

