/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.BugtraqOptionsArea;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PromptForBugtraqPropertiesDialog
extends TitleAreaDialog {
    private final IProject project;
    private SVNWorkItemAdapter workItemAdapter;
    private BugtraqOptionsArea bugtraqArea;
    private String message;
    private boolean firstTime = true;
    private ITeamRepository teamRepository;
    private boolean createConnection;

    public PromptForBugtraqPropertiesDialog(Shell parentShell, IProject project, SVNWorkItemAdapter adapter) {
        super(parentShell);
        this.project = project;
        this.workItemAdapter = adapter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SVNRCPMessages.PromptForBugtraqPropertiesDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(SVNRCPMessages.PromptForBugtraqPropertiesDialog_1);
        this.message = SVNRCPMessages.PromptForBugtraqPropertiesDialog_2;
        this.setMessage(this.message);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 64);
        label.setText(NLS.bind((String)SVNRCPMessages.PromptForBugtraqPropertiesDialog_3, (Object)this.project.getName()));
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        this.bugtraqArea = new BugtraqOptionsArea(composite, this.project, this.workItemAdapter, true);
        this.bugtraqArea.getValidationStatus().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                PromptForBugtraqPropertiesDialog.this.updateEnablements();
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(LayoutConstants2.getGroupMargins()).generateLayout(composite);
        this.updateEnablements();
        PromptForBugtraqPropertiesDialog.applyDialogFont((Control)dialogArea);
        this.bugtraqArea.initControls();
        this.bugtraqArea.setEnabled(true);
        return dialogArea;
    }

    private Group createGroup(Composite composite, String name) {
        Group group = new Group(composite, 0);
        group.setText(name);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        return group;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateEnablements();
    }

    protected void updateEnablements() {
        Object value = this.bugtraqArea.getValidationStatus().getValue();
        if (value instanceof IStatus) {
            IStatus status = (IStatus)value;
            this.setOkButtonEnablement(status.getSeverity() != 4);
            if (!status.isOK()) {
                if (!this.firstTime) {
                    this.setMessage(status.getMessage(), this.getErrorType(status));
                }
            } else if (this.bugtraqArea.getRepository() == null) {
                this.setOkButtonEnablement(false);
                this.setMessage(this.message, 0);
            } else {
                this.setMessage(this.message, 0);
            }
        } else {
            this.setOkButtonEnablement(true);
        }
    }

    protected Control createContents(Composite parent) {
        Control createContents = super.createContents(parent);
        this.firstTime = false;
        return createContents;
    }

    private void setOkButtonEnablement(boolean b) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(b);
        }
    }

    private int getErrorType(IStatus status) {
        if (status.getSeverity() == 4) {
            return 3;
        }
        if (status.getSeverity() == 2) {
            return 2;
        }
        return 1;
    }

    protected void okPressed() {
        this.teamRepository = this.bugtraqArea.getRepository();
        this.bugtraqArea.updateProperties();
        this.createConnection = this.bugtraqArea.isCreateConnection();
        super.okPressed();
    }

    public ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }

    public boolean isCreateConnection() {
        return this.createConnection;
    }
}

