/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.scm.svn.common.RevisionLinks;
import com.ibm.team.scm.svn.common.SVNWorkItemExtractor;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.AbstractWorkItemAction;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.LinkToWorkItemsAction;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class OpenWorkItemsAction
extends AbstractWorkItemAction {
    public void run(final Shell shell, final IWorkbenchPage page, final IStructuredSelection selection) {
        final IURIReference svnReference = this.getSelectedRevisionReference(selection);
        final UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(SVNRCPMessages.OpenWorkItemsAction_0, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                final ITeamRepository teamRepository = OpenWorkItemsAction.this.getTeamRepository(context, selection, (IProgressMonitor)progress.newChild(10));
                if (teamRepository == null) {
                    return;
                }
                final ProviderFactory providerFactory = OpenWorkItemsAction.getProviderFactory(teamRepository);
                final List links = OpenWorkItemsAction.this.findLinks(selection, svnReference, providerFactory, teamRepository, progress.newChild(90));
                context.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (links.size() == 0) {
                            this.handleNoLinks(providerFactory, svnReference, teamRepository);
                        } else {
                            this.openWorkItems(links);
                        }
                    }
                });
            }

            private void handleNoLinks(ProviderFactory providerFactory, IURIReference svnReference2, ITeamRepository teamRepository) {
                if (MessageDialog.openQuestion((Shell)shell, (String)SVNRCPMessages.OpenWorkItemsAction_1, (String)SVNRCPMessages.OpenWorkItemsAction_2)) {
                    IWorkItemHandle[] handles = LinkToWorkItemsAction.linkWorkItemsToRevision(context, svnReference2, teamRepository, providerFactory, OpenWorkItemsAction.this.getWorkItemAdapter());
                    this.openWorkItems(handles);
                }
            }

            private void openWorkItems(List<IWorkItemHandle> handles) {
                for (IWorkItemHandle workItemHandle : handles) {
                    WorkItemUI.open((IWorkbenchPage)page, (Object)workItemHandle);
                }
            }

            private void openWorkItems(IWorkItemHandle[] handles) {
                int i = 0;
                while (i < handles.length) {
                    IWorkItemHandle workItemHandle = handles[i];
                    WorkItemUI.open((IWorkbenchPage)page, (Object)workItemHandle);
                    ++i;
                }
            }
        });
    }

    private List<IWorkItemHandle> findLinks(IStructuredSelection selection, IURIReference svnReference, ProviderFactory providerFactory, ITeamRepository teamRepository, SubMonitor progress) throws TeamRepositoryException {
        progress.beginTask(null, 100);
        List<IWorkItemHandle> workItemsFromComment = this.getWorkItemAdapter().getWorkItems(selection.getFirstElement(), teamRepository, this.getWorkItemExtractor(teamRepository, (IProgressMonitor)progress.newChild(10)), (IProgressMonitor)progress.newChild(10));
        List links = RevisionLinks.findLinks((LinkProvider)providerFactory.getLinkProvider(), (IReference)svnReference, (IProgressMonitor)progress.newChild(80));
        IWorkItemHandle[] workItemsFromLinks = RevisionLinks.getWorkItemHandles((List)links);
        int i = 0;
        while (i < workItemsFromLinks.length) {
            IWorkItemHandle handle = workItemsFromLinks[i];
            if (!this.contains(workItemsFromComment, handle)) {
                workItemsFromComment.add(handle);
            }
            ++i;
        }
        return workItemsFromComment;
    }

    private SVNWorkItemExtractor getWorkItemExtractor(ITeamRepository teamRepository, IProgressMonitor monitor) {
        SVNWorkItemExtractor workItemExtractor;
        try {
            workItemExtractor = SVNWorkItemExtractor.create((IAuditableCommon)((IAuditableCommon)teamRepository.getClientLibrary(IAuditableClient.class)), (IWorkItemCommon)((IWorkItemCommon)teamRepository.getClientLibrary(IWorkItemClient.class)), (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException e) {
            this.getWorkItemAdapter().logException(e);
            workItemExtractor = SVNWorkItemExtractor.getInstance();
        }
        return workItemExtractor;
    }

    private boolean contains(List<IWorkItemHandle> workItemsFromComment, IWorkItemHandle handle) {
        for (IWorkItemHandle other : workItemsFromComment) {
            if (!other.getItemId().equals((Object)handle.getItemId())) continue;
            return true;
        }
        return false;
    }
}

