/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.scm.svn.common.RevisionLinks;
import com.ibm.team.scm.svn.common.SVNWorkItemExtractor;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.AbstractWorkItemAction;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class LocalLinkUpdateOperation {
    private final String url;
    private final long startingRevision;
    private long latestRevision;
    private final ITeamRepository teamRepository;
    private SVNWorkItemExtractor workItemExtractor;
    private final SVNWorkItemAdapter workItemAdapter;

    public LocalLinkUpdateOperation(ITeamRepository teamRepository, String url, long startingRevision, SVNWorkItemAdapter workItemAdapter) {
        this.teamRepository = teamRepository;
        this.url = url;
        this.startingRevision = startingRevision;
        this.workItemAdapter = workItemAdapter;
    }

    public String getUrl() {
        return this.url;
    }

    public long getStartingRevision() {
        return this.startingRevision;
    }

    public long getLatestRevision() {
        return this.latestRevision;
    }

    public void setLatestRevision(long latestRevision) {
        this.latestRevision = latestRevision;
    }

    public ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }

    protected void createLinks(IURIReference uriReference, String message, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        List ids = this.getWorkItemExtractor((IProgressMonitor)progress.newChild(10)).extractWorkItemNumbers(null, message, true);
        List<IWorkItemHandle> workItems = this.getWorkItemAdapter().getWorkItems(this.getWorkItemAdapter().getWorkItemUrl(this.teamRepository, "%BUGID%"), ids, (IProgressMonitor)progress.newChild(50));
        RevisionLinks.createLink((LinkProvider)AbstractWorkItemAction.getProviderFactory(this.teamRepository).getLinkProvider(), (IURIReference)uriReference, workItems, (IProgressMonitor)progress.newChild(50));
    }

    private SVNWorkItemExtractor getWorkItemExtractor(IProgressMonitor monitor) {
        if (this.workItemExtractor == null) {
            try {
                this.workItemExtractor = SVNWorkItemExtractor.create((IAuditableCommon)((IAuditableCommon)this.teamRepository.getClientLibrary(IAuditableClient.class)), (IWorkItemCommon)((IWorkItemCommon)this.teamRepository.getClientLibrary(IWorkItemClient.class)), (IProgressMonitor)monitor);
            }
            catch (TeamRepositoryException e) {
                this.getWorkItemAdapter().logException(e);
                this.workItemExtractor = SVNWorkItemExtractor.getInstance();
            }
        }
        return this.workItemExtractor;
    }

    public abstract void runLocalUpdate(IProgressMonitor var1) throws TeamRepositoryException;

    public final SVNWorkItemAdapter getWorkItemAdapter() {
        return this.workItemAdapter;
    }
}

